/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.batchlucene;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;
import org.hibernate.search.backend.impl.batchlucene.BatchBackend;
import org.hibernate.search.backend.impl.batchlucene.DirectoryProviderWorkspace;
import org.hibernate.search.backend.impl.lucene.DpSelectionVisitor;
import org.hibernate.search.backend.impl.lucene.PerDirectoryWorkProcessor;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;

public class LuceneBatchBackend
implements BatchBackend {
    public static final String CONCURRENT_WRITERS = "hibernate.search.batchbackend.concurrent_writers";
    private static final DpSelectionVisitor providerSelectionVisitor = new DpSelectionVisitor();
    private SearchFactoryImplementor searchFactoryImplementor;
    private final Map<DirectoryProvider<?>, DirectoryProviderWorkspace> resourcesMap = new HashMap();
    private final PerDirectoryWorkProcessor asyncWorker = new AsyncBatchPerDirectoryWorkProcessor();
    private final PerDirectoryWorkProcessor syncWorker = new SyncBatchPerDirectoryWorkProcessor();

    public void initialize(Properties cfg, MassIndexerProgressMonitor monitor, SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        int maxThreadsPerIndex = ConfigurationParseHelper.getIntValue(cfg, "concurrent_writers", 2);
        if (maxThreadsPerIndex < 1) {
            throw new SearchException("concurrent_writers for batch backend must be at least 1.");
        }
        for (DirectoryProvider<?> dp : searchFactoryImplementor.getDirectoryProviders()) {
            DirectoryProviderWorkspace resources = new DirectoryProviderWorkspace(searchFactoryImplementor, dp, monitor, maxThreadsPerIndex);
            this.resourcesMap.put(dp, resources);
        }
    }

    public void enqueueAsyncWork(LuceneWork work) throws InterruptedException {
        this.sendWorkToShards(work, this.asyncWorker);
    }

    public void doWorkInSync(LuceneWork work) {
        try {
            this.sendWorkToShards(work, this.syncWorker);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SearchException("AssertionFailure");
        }
    }

    public void stopAndFlush(long timeout, TimeUnit unit) throws InterruptedException {
        for (DirectoryProviderWorkspace res : this.resourcesMap.values()) {
            res.stopAndFlush(timeout, unit);
        }
    }

    public void close() {
        Throwable error = null;
        for (DirectoryProviderWorkspace res : this.resourcesMap.values()) {
            try {
                res.close();
            }
            catch (Throwable t) {
                error = t;
            }
        }
        if (error != null) {
            throw new SearchException("Error while closing massindexer", error);
        }
    }

    private void sendWorkToShards(LuceneWork work, PerDirectoryWorkProcessor worker) throws InterruptedException {
        Class entityType = work.getEntityClass();
        DocumentBuilderIndexedEntity documentBuilder = this.searchFactoryImplementor.getDocumentBuilderIndexedEntity(entityType);
        IndexShardingStrategy shardingStrategy = documentBuilder.getDirectoryProviderSelectionStrategy();
        work.getWorkDelegate(providerSelectionVisitor).addAsPayLoadsToQueue(work, shardingStrategy, worker);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SyncBatchPerDirectoryWorkProcessor
    implements PerDirectoryWorkProcessor {
        private SyncBatchPerDirectoryWorkProcessor() {
        }

        @Override
        public void addWorkToDpProcessor(DirectoryProvider<?> dp, LuceneWork work) {
            ((DirectoryProviderWorkspace)LuceneBatchBackend.this.resourcesMap.get(dp)).doWorkInSync(work);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncBatchPerDirectoryWorkProcessor
    implements PerDirectoryWorkProcessor {
        private AsyncBatchPerDirectoryWorkProcessor() {
        }

        @Override
        public void addWorkToDpProcessor(DirectoryProvider<?> dp, LuceneWork work) throws InterruptedException {
            ((DirectoryProviderWorkspace)LuceneBatchBackend.this.resourcesMap.get(dp)).enqueueAsyncWork(work);
        }
    }
}

