/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.util.Map;
import java.util.Properties;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.backend.Worker;
import org.hibernate.search.backend.impl.TransactionalWorker;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.PluginLoader;

public abstract class WorkerFactory {
    private static Properties getProperties(SearchConfiguration cfg) {
        Properties props = cfg.getProperties();
        Properties workerProperties = new Properties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("hibernate.search.worker.")) continue;
            workerProperties.setProperty(key, (String)entry.getValue());
        }
        return workerProperties;
    }

    public static Worker createWorker(SearchConfiguration cfg, WorkerBuildContext context) {
        Properties props = WorkerFactory.getProperties(cfg);
        String impl = props.getProperty("hibernate.search.worker.scope");
        Worker worker = StringHelper.isEmpty((String)impl) ? new TransactionalWorker() : ("transaction".equalsIgnoreCase(impl) ? new TransactionalWorker() : PluginLoader.instanceFromName(Worker.class, impl, WorkerFactory.class, "worker"));
        worker.initialize(props, context);
        return worker;
    }
}

