/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class SerializationTestHelper
extends TestCase {
    public static Object duplicateBySerialization(Object o) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutStream = new ObjectOutputStream(outStream);
        objectOutStream.writeObject(o);
        objectOutStream.flush();
        objectOutStream.close();
        byte[] objectBuffer = outStream.toByteArray();
        ByteArrayInputStream inStream = new ByteArrayInputStream(objectBuffer);
        ObjectInputStream objectInStream = new ObjectInputStream(inStream);
        Object copy = objectInStream.readObject();
        return copy;
    }

    public void testSelf() throws IOException, ClassNotFoundException {
        Foo a = new Foo();
        a.list.add(new Foo.TestInnerClass(30));
        Foo b = (Foo)SerializationTestHelper.duplicateBySerialization(a);
        SerializationTestHelper.assertEquals((Object)6, (Object)a.integer);
        SerializationTestHelper.assertEquals((Object)7, (Object)b.integer);
        SerializationTestHelper.assertEquals(a.list, b.list);
    }

    static class Foo
    implements Serializable {
        List<TestInnerClass> list = new ArrayList<TestInnerClass>();
        transient Integer integer = 6;

        Foo() {
        }

        private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
            aInputStream.defaultReadObject();
            this.integer = 7;
        }

        private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
            aOutputStream.defaultWriteObject();
        }

        static class TestInnerClass
        implements Serializable {
            private final int v;

            public TestInnerClass(int i) {
                this.v = i;
            }

            public void print() {
                System.out.println(this.v);
            }

            public String toString() {
                return "" + this.v;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.v;
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                TestInnerClass other = (TestInnerClass)obj;
                return this.v == other.v;
            }
        }
    }
}

