/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.io.Serializable;
import org.apache.lucene.store.LockObtainFailedException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.LogErrorHandler;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.batchindexing.ConcurrentData;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoNotCloseOnLockTimeoutTest
extends SearchTestCase {
    private static Logger log = LoggerFactory.make();
    public static final int NBR_OF_OBJECTS_TESTED = 2000;

    public void testTimeoutException() throws Exception {
        FailOnSomeExceptionErrorHandler.hasFailed = null;
        FullTextSession session = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = session.beginTransaction();
        for (int i = 0; i < 2000; ++i) {
            session.persist((Object)new ConcurrentData("concurrent data " + i));
            if (i % 1000 != 0) continue;
            tx.commit();
            session.clear();
            tx = session.beginTransaction();
        }
        tx.commit();
        session.clear();
        Thread massIndexer = new Thread(new MassindexerWork());
        massIndexer.start();
        for (int i = 1; i < 2000; ++i) {
            tx = session.beginTransaction();
            ConcurrentData data = (ConcurrentData)session.get(ConcurrentData.class, (Serializable)new Long(i));
            if (i % 10 == 0) {
                log.debug("****** Editing " + i);
                data.setData("This is a new data " + i);
                tx.commit();
                session.clear();
                tx = session.beginTransaction();
            }
            tx.commit();
        }
        session.clear();
        massIndexer.join();
        tx = session.beginTransaction();
        session.createQuery("delete from " + ConcurrentData.class.getName()).executeUpdate();
        tx.commit();
        session.close();
        if (FailOnSomeExceptionErrorHandler.hasFailed != null) {
            FailOnSomeExceptionErrorHandler.hasFailed.printStackTrace();
            DoNotCloseOnLockTimeoutTest.fail((String)("Unexpected exception while indexing:" + FailOnSomeExceptionErrorHandler.hasFailed.getMessage()));
        }
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{ConcurrentData.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.error_handler", FailOnSomeExceptionErrorHandler.class.getName());
    }

    public static class FailOnSomeExceptionErrorHandler
    extends LogErrorHandler
    implements ErrorHandler {
        public static volatile Throwable hasFailed;

        public void handle(ErrorContext context) {
            if (hasFailed == null && context.getThrowable() != null && !(context.getThrowable().getCause() instanceof LockObtainFailedException)) {
                hasFailed = context.getThrowable();
                super.handle(context);
            }
            if (context.getThrowable() != null && !(context.getThrowable().getCause() instanceof LockObtainFailedException)) {
                super.handle(context);
            }
        }
    }

    private class MassindexerWork
    implements Runnable {
        private MassindexerWork() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FullTextSession session = Search.getFullTextSession((Session)DoNotCloseOnLockTimeoutTest.this.openSession());
            try {
                session.createIndexer(new Class[]{ConcurrentData.class}).startAndWait();
                session.createIndexer(new Class[]{ConcurrentData.class}).startAndWait();
            }
            catch (InterruptedException e) {
                log.error("Error while reindexing", (Throwable)e);
            }
            finally {
                session.close();
            }
        }
    }
}

