/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.batchindexing.Book;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Nation {
    private Integer id;
    private String name;
    private String code;
    private Set<Book> librariesHave = new HashSet<Book>();

    public Nation() {
    }

    public Nation(String name, String code) {
        this.name = name;
        this.code = code;
    }

    @Id
    @GeneratedValue
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Field
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Field(index=Index.UN_TOKENIZED)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @IndexedEmbedded
    @OneToMany(fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SELECT)
    public Set<Book> getLibrariesHave() {
        return this.librariesHave;
    }

    public void setLibrariesHave(Set<Book> librariesHave) {
        this.librariesHave = librariesHave;
    }
}

