/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.util.Set;
import junit.framework.TestCase;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.impl.MassIndexerImpl;
import org.hibernate.search.test.batchindexing.AncientBook;
import org.hibernate.search.test.batchindexing.Book;
import org.hibernate.search.test.batchindexing.Dvd;
import org.hibernate.search.test.batchindexing.ModernBook;
import org.hibernate.search.test.batchindexing.Nation;
import org.hibernate.search.test.util.FullTextSessionBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchIndexerTest
extends TestCase {
    public void testEntityHierarchy() {
        FullTextSessionBuilder ftsb = new FullTextSessionBuilder().addAnnotatedClass(ModernBook.class).addAnnotatedClass(AncientBook.class).addAnnotatedClass(Dvd.class).addAnnotatedClass(Book.class).addAnnotatedClass(Nation.class).build();
        FullTextSession fullTextSession = ftsb.openFullTextSession();
        SearchFactoryImplementor searchFactory = (SearchFactoryImplementor)fullTextSession.getSearchFactory();
        TestableMassIndexerImpl tsii = new TestableMassIndexerImpl(searchFactory, Book.class);
        SearchIndexerTest.assertTrue((boolean)tsii.getRootEntities().contains(Book.class));
        SearchIndexerTest.assertFalse((boolean)tsii.getRootEntities().contains(ModernBook.class));
        SearchIndexerTest.assertFalse((boolean)tsii.getRootEntities().contains(AncientBook.class));
        tsii = new TestableMassIndexerImpl(searchFactory, ModernBook.class, AncientBook.class, Book.class);
        SearchIndexerTest.assertTrue((boolean)tsii.getRootEntities().contains(Book.class));
        SearchIndexerTest.assertFalse((boolean)tsii.getRootEntities().contains(ModernBook.class));
        SearchIndexerTest.assertFalse((boolean)tsii.getRootEntities().contains(AncientBook.class));
        tsii = new TestableMassIndexerImpl(searchFactory, ModernBook.class, AncientBook.class);
        SearchIndexerTest.assertFalse((boolean)tsii.getRootEntities().contains(Book.class));
        SearchIndexerTest.assertTrue((boolean)tsii.getRootEntities().contains(ModernBook.class));
        SearchIndexerTest.assertTrue((boolean)tsii.getRootEntities().contains(AncientBook.class));
        tsii = new TestableMassIndexerImpl(searchFactory, Object.class);
        SearchIndexerTest.assertTrue((boolean)tsii.getRootEntities().contains(Book.class));
        SearchIndexerTest.assertTrue((boolean)tsii.getRootEntities().contains(Dvd.class));
        SearchIndexerTest.assertFalse((boolean)tsii.getRootEntities().contains(AncientBook.class));
        SearchIndexerTest.assertFalse((boolean)tsii.getRootEntities().contains(Object.class));
        SearchIndexerTest.assertEquals((int)2, (int)tsii.getRootEntities().size());
        fullTextSession.close();
        ftsb.close();
    }

    public void testIdentifierNaming() throws InterruptedException {
        FullTextSessionBuilder ftsb = new FullTextSessionBuilder().setProperty("hibernate.search.analyzer", StandardAnalyzer.class.getName()).addAnnotatedClass(Dvd.class).addAnnotatedClass(Nation.class).addAnnotatedClass(Book.class).setProperty("hibernate.search.indexing_strategy", "manual").build();
        FullTextSession fullTextSession = ftsb.openFullTextSession();
        Transaction transaction = fullTextSession.beginTransaction();
        Nation us = new Nation("United States of America", "US");
        fullTextSession.persist((Object)us);
        Dvd dvda = new Dvd();
        dvda.setTitle("Star Trek (episode 96367)");
        dvda.setFirstPublishedIn(us);
        fullTextSession.save((Object)dvda);
        Dvd dvdb = new Dvd();
        dvdb.setTitle("The Trek");
        dvdb.setFirstPublishedIn(us);
        fullTextSession.save((Object)dvdb);
        transaction.commit();
        fullTextSession.close();
        SearchIndexerTest.assertEquals((int)0, (int)this.countResults(new Term("title", "trek"), ftsb, Dvd.class));
        fullTextSession = ftsb.openFullTextSession();
        fullTextSession.createIndexer(new Class[]{Dvd.class}).startAndWait();
        fullTextSession.close();
        SearchIndexerTest.assertEquals((int)2, (int)this.countResults(new Term("title", "trek"), ftsb, Dvd.class));
        ftsb.close();
    }

    private int countResults(Term termForQuery, FullTextSessionBuilder ftSessionBuilder, Class<?> type) {
        TermQuery fullTextQuery = new TermQuery(termForQuery);
        FullTextSession fullTextSession = ftSessionBuilder.openFullTextSession();
        Transaction transaction = fullTextSession.beginTransaction();
        FullTextQuery query = fullTextSession.createFullTextQuery((Query)fullTextQuery, new Class[]{type});
        int resultSize = query.getResultSize();
        transaction.commit();
        fullTextSession.close();
        return resultSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestableMassIndexerImpl
    extends MassIndexerImpl {
        protected TestableMassIndexerImpl(SearchFactoryImplementor searchFactory, Class<?> ... types) {
            super(searchFactory, null, (Class[])types);
        }

        public Set<Class<?>> getRootEntities() {
            return this.rootEntities;
        }
    }
}

