/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import java.io.File;
import java.util.Properties;
import junit.framework.TestCase;
import org.hibernate.search.SearchException;
import org.hibernate.search.store.DirectoryProviderHelper;
import org.hibernate.search.util.FileHelper;

public class DirectoryProviderHelperTest
extends TestCase {
    public void testMkdirsDetermineIndex() {
        String root = "./testDir/dir1/dir2";
        String relative = "dir3";
        Properties properties = new Properties();
        properties.put("indexBase", root);
        properties.put("indexName", relative);
        DirectoryProviderHelper.getVerifiedIndexDir((String)"name", (Properties)properties, (boolean)true);
        DirectoryProviderHelperTest.assertTrue((boolean)new File(root).exists());
        FileHelper.delete((File)new File("./testDir"));
    }

    public void testMkdirsGetSource() {
        String root = "./testDir";
        String relative = "dir1/dir2/dir3";
        Properties properties = new Properties();
        properties.put("sourceBase", root);
        properties.put("source", relative);
        File rel = DirectoryProviderHelper.getSourceDirectory((String)"name", (Properties)properties, (boolean)true);
        DirectoryProviderHelperTest.assertTrue((boolean)rel.exists());
        FileHelper.delete((File)new File(root));
    }

    public void testConfiguringCopyBufferSize() {
        Properties prop = new Properties();
        long mB = 0x100000L;
        DirectoryProviderHelperTest.assertEquals((long)0x1000000L, (long)DirectoryProviderHelper.getCopyBufferSize((String)"testIdx", (Properties)prop));
        prop.setProperty("buffer_size_on_copy", "4");
        DirectoryProviderHelperTest.assertEquals((long)(4L * mB), (long)DirectoryProviderHelper.getCopyBufferSize((String)"testIdx", (Properties)prop));
        prop.setProperty("buffer_size_on_copy", "1000");
        DirectoryProviderHelperTest.assertEquals((long)(1000L * mB), (long)DirectoryProviderHelper.getCopyBufferSize((String)"testIdx", (Properties)prop));
        prop.setProperty("buffer_size_on_copy", "0");
        boolean testOk = false;
        try {
            DirectoryProviderHelper.getCopyBufferSize((String)"testIdx", (Properties)prop);
        }
        catch (SearchException e) {
            testOk = true;
        }
        DirectoryProviderHelperTest.assertTrue((boolean)testOk);
        prop.setProperty("buffer_size_on_copy", "-100");
        testOk = false;
        try {
            DirectoryProviderHelper.getCopyBufferSize((String)"testIdx", (Properties)prop);
        }
        catch (SearchException e) {
            testOk = true;
        }
        DirectoryProviderHelperTest.assertTrue((boolean)testOk);
    }
}

