/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.FSDirectoryProvider;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.directoryProvider.SnowStorm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSDirectorySelectionTest
extends SearchTestCase {
    public void testMMapDirectoryType() throws Exception {
        SessionFactory factory = this.createSessionFactoryUsingDirectoryType("mmap");
        this.assertCorrectDirectoryType(factory, MMapDirectory.class.getName());
    }

    public void testNIODirectoryType() throws Exception {
        SessionFactory factory = this.createSessionFactoryUsingDirectoryType("nio");
        this.assertCorrectDirectoryType(factory, NIOFSDirectory.class.getName());
    }

    public void testSimpleDirectoryType() throws Exception {
        SessionFactory factory = this.createSessionFactoryUsingDirectoryType("simple");
        this.assertCorrectDirectoryType(factory, SimpleFSDirectory.class.getName());
    }

    public void testInvalidDirectoryType() throws Exception {
        try {
            this.createSessionFactoryUsingDirectoryType("foobar");
            FSDirectorySelectionTest.fail((String)"Factory creation should fail with invalid 'hibernate.search.default.filesystem_access_type' parameter ");
        }
        catch (HibernateException e) {
            FSDirectorySelectionTest.assertTrue((boolean)(e.getCause() instanceof SearchException));
        }
    }

    private void assertCorrectDirectoryType(SessionFactory factory, String className) {
        org.hibernate.classic.Session session = factory.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        DirectoryProvider[] providers = fullTextSession.getSearchFactory().getDirectoryProviders(SnowStorm.class);
        FSDirectorySelectionTest.assertTrue((String)"Wrong number of directory providers", (providers.length == 1 ? 1 : 0) != 0);
        Directory directory = providers[0].getDirectory();
        FSDirectorySelectionTest.assertEquals((String)"Wrong directory provider type", (String)className, (String)directory.getClass().getName());
    }

    private SessionFactory createSessionFactoryUsingDirectoryType(String directoryType) {
        AnnotationConfiguration config = new AnnotationConfiguration();
        config.addAnnotatedClass(SnowStorm.class);
        config.setProperty("hibernate.search.default.indexBase", this.getBaseIndexDir().getAbsolutePath());
        config.setProperty("hibernate.search.default.directory_provider", FSDirectoryProvider.class.getName());
        config.setProperty("hibernate.search.default.filesystem_access_type", directoryType);
        return config.buildSessionFactory();
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[0];
    }
}

