/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.errorhandling;

import junit.framework.Assert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.errorhandling.MockErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentMergeErrorHandledTest
extends SearchTestCase {
    public void testLuceneMergerErrorHandling() {
        SearchFactoryImplementor searchFactory = this.getSearchFactoryImpl();
        ErrorHandler errorHandler = searchFactory.getErrorHandler();
        Assert.assertTrue((boolean)(errorHandler instanceof MockErrorHandler));
        MockErrorHandler mockErrorHandler = (MockErrorHandler)errorHandler;
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        session.persist((Object)new Document("Byteman Programmers Guider", "Version 1.5.0 Draft", "contains general guidelines to use Byteman"));
        transaction.commit();
        session.close();
        String errorMessage = mockErrorHandler.getErrorMessage();
        Assert.assertEquals((String)"Exception occurred java.io.IOException: Byteman said: your disk is full!\n", (String)errorMessage);
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class};
    }

    protected SearchFactoryImplementor getSearchFactoryImpl() {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        s.close();
        SearchFactory searchFactory = s.getSearchFactory();
        return (SearchFactoryImplementor)searchFactory;
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.error_handler", MockErrorHandler.class.getName());
    }
}

