/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.errorhandling;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.WorkVisitor;
import org.hibernate.search.backend.impl.lucene.DpSelectionVisitor;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.LogErrorHandler;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.errorhandling.MockErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneErrorHandlingTest
extends SearchTestCase {
    static final AtomicInteger workcounter = new AtomicInteger();

    public void testErrorHandling() {
        SearchFactoryImplementor searchFactory = this.getSearchFactoryImpl();
        ErrorHandler errorHandler = searchFactory.getErrorHandler();
        Assert.assertTrue((boolean)(errorHandler instanceof MockErrorHandler));
        MockErrorHandler mockErrorHandler = (MockErrorHandler)errorHandler;
        BackendQueueProcessorFactory queueProcessorFactory = searchFactory.getBackendQueueProcessorFactory();
        ArrayList<DeleteLuceneWork> queue = new ArrayList<DeleteLuceneWork>();
        queue.add(new HarmlessWork("firstWork"));
        queue.add(new HarmlessWork("secondWork"));
        Runnable processor = queueProcessorFactory.getProcessor(queue);
        workcounter.set(0);
        processor.run();
        Assert.assertEquals((int)2, (int)workcounter.get());
        workcounter.set(0);
        FailingWork firstFailure = new FailingWork("firstFailure");
        queue.add(firstFailure);
        HarmlessWork thirdWork = new HarmlessWork("thirdWork");
        queue.add(thirdWork);
        HarmlessWork fourthWork = new HarmlessWork("fourthWork");
        queue.add(fourthWork);
        processor = queueProcessorFactory.getProcessor(queue);
        processor.run();
        Assert.assertEquals((int)2, (int)workcounter.get());
        String errorMessage = mockErrorHandler.getErrorMessage();
        Throwable exception = mockErrorHandler.getLastException();
        StringBuilder expectedErrorMessage = new StringBuilder();
        expectedErrorMessage.append("Exception occurred ").append(exception).append("\n");
        expectedErrorMessage.append("Primary Failure:\n");
        LogErrorHandler.appendFailureMessage((StringBuilder)expectedErrorMessage, (LuceneWork)firstFailure);
        expectedErrorMessage.append("Subsequent failures:\n");
        LogErrorHandler.appendFailureMessage((StringBuilder)expectedErrorMessage, (LuceneWork)thirdWork);
        LogErrorHandler.appendFailureMessage((StringBuilder)expectedErrorMessage, (LuceneWork)fourthWork);
        Assert.assertEquals((String)expectedErrorMessage.toString(), (String)errorMessage);
        Assert.assertTrue((boolean)(exception instanceof SearchException));
        Assert.assertEquals((String)"failed work message", (String)exception.getMessage());
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.error_handler", MockErrorHandler.class.getName());
    }

    protected SearchFactoryImplementor getSearchFactoryImpl() {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        s.close();
        SearchFactory searchFactory = s.getSearchFactory();
        return (SearchFactoryImplementor)searchFactory;
    }

    static class FailingLuceneWorkDelegate
    implements LuceneWorkDelegate {
        FailingLuceneWorkDelegate() {
        }

        public void logWorkDone(LuceneWork work, MassIndexerProgressMonitor monitor) {
        }

        public void performWork(LuceneWork work, IndexWriter writer) {
            throw new SearchException("failed work message");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FailingWork
    extends DeleteLuceneWork {
        public FailingWork(String workIdentifier) {
            super((Serializable)((Object)workIdentifier), workIdentifier, Document.class);
        }

        public <T> T getWorkDelegate(WorkVisitor<T> visitor) {
            if (visitor instanceof DpSelectionVisitor) {
                return (T)visitor.getDelegate((DeleteLuceneWork)this);
            }
            return (T)new FailingLuceneWorkDelegate();
        }

        public String toString() {
            return "FailingWork: " + this.getIdInString();
        }
    }

    static class NoOpLuceneWorkDelegate
    implements LuceneWorkDelegate {
        NoOpLuceneWorkDelegate() {
        }

        public void logWorkDone(LuceneWork work, MassIndexerProgressMonitor monitor) {
        }

        public void performWork(LuceneWork work, IndexWriter writer) {
            workcounter.incrementAndGet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HarmlessWork
    extends DeleteLuceneWork {
        public HarmlessWork(String workIdentifier) {
            super((Serializable)((Object)workIdentifier), workIdentifier, Document.class);
        }

        public <T> T getWorkDelegate(WorkVisitor<T> visitor) {
            if (visitor instanceof DpSelectionVisitor) {
                return (T)visitor.getDelegate((DeleteLuceneWork)this);
            }
            return (T)new NoOpLuceneWorkDelegate();
        }

        public String toString() {
            return "HarmlessWork: " + this.getIdInString();
        }
    }
}

