/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id.providedId;

import java.io.Serializable;
import junit.framework.TestCase;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.id.providedId.ProvidedIdPerson;
import org.hibernate.search.test.id.providedId.ProvidedIdPersonSub;
import org.hibernate.search.test.util.ManualConfiguration;
import org.hibernate.search.test.util.ManualTransactionContext;

public class ProvidedIdTest
extends TestCase {
    public void testProvidedId() throws Exception {
        ManualConfiguration configuration = new ManualConfiguration().addClass(ProvidedIdPerson.class).addClass(ProvidedIdPersonSub.class).addProperty("hibernate.search.default.directory_provider", "ram").addProperty("hibernate.search.analyzer", StopAnalyzer.class.getName()).addProperty("hibernate.search.default.transaction.merge_factor", "100").addProperty("hibernate.search.default.batch.max_buffered_docs", "1000");
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        ProvidedIdPerson person1 = new ProvidedIdPerson();
        person1.setName("Big Goat");
        person1.setBlurb("Eats grass");
        ProvidedIdPerson person2 = new ProvidedIdPerson();
        person2.setName("Mini Goat");
        person2.setBlurb("Eats cheese");
        ProvidedIdPersonSub person3 = new ProvidedIdPersonSub();
        person3.setName("Regular goat");
        person3.setBlurb("Is anorexic");
        ManualTransactionContext tc = new ManualTransactionContext();
        Work work = new Work((Object)person1, (Serializable)Integer.valueOf(1), WorkType.INDEX);
        sf.getWorker().performWork(work, (TransactionContext)tc);
        work = new Work((Object)person2, (Serializable)Integer.valueOf(2), WorkType.INDEX);
        sf.getWorker().performWork(work, (TransactionContext)tc);
        Work work2 = new Work((Object)person3, (Serializable)Integer.valueOf(3), WorkType.INDEX);
        sf.getWorker().performWork(work2, (TransactionContext)tc);
        tc.end();
        QueryParser parser = new QueryParser(SearchTestCase.getTargetLuceneVersion(), "name", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("Goat");
        DirectoryProvider provider = sf.getDirectoryProviders(ProvidedIdPerson.class)[0];
        IndexSearcher searcher = new IndexSearcher(provider.getDirectory(), true);
        TopDocs hits = searcher.search(luceneQuery, 1000);
        ProvidedIdTest.assertEquals((int)3, (int)hits.totalHits);
        searcher.close();
    }
}

