/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import junit.framework.TestCase;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.test.query.AlternateBook;
import org.hibernate.search.test.query.Employee;
import org.hibernate.search.test.util.FullTextSessionBuilder;

public class ScrollableResultsTest
extends TestCase {
    private FullTextSessionBuilder builder;
    private FullTextSession sess;

    public void setUp() throws Exception {
        int i;
        super.setUp();
        this.builder = new FullTextSessionBuilder();
        this.builder.addAnnotatedClass(AlternateBook.class).addAnnotatedClass(Employee.class).setProperty("hibernate.default_batch_fetch_size", "10").build();
        this.sess = this.builder.openFullTextSession();
        Transaction tx = this.sess.beginTransaction();
        for (i = 0; i < 324; ++i) {
            this.sess.persist((Object)new AlternateBook(i, "book about the number " + i));
        }
        for (i = 0; i < 133; ++i) {
            this.sess.persist((Object)new Employee(i, "Rossi", "dept. num. " + i));
        }
        tx.commit();
    }

    protected void tearDown() throws Exception {
        this.builder.close();
        super.tearDown();
    }

    public void testScrollingForward() {
        Transaction tx = this.sess.beginTransaction();
        TermQuery tq = new TermQuery(new Term("summary", "number"));
        Sort sort = new Sort(new SortField("id", 3));
        ScrollableResults scrollableResults = this.sess.createFullTextQuery((Query)tq, new Class[]{AlternateBook.class}).setSort(sort).setFetchSize(10).setFirstResult(20).setMaxResults(111).scroll();
        ScrollableResultsTest.assertEquals((int)-1, (int)scrollableResults.getRowNumber());
        ScrollableResultsTest.assertTrue((boolean)scrollableResults.last());
        ScrollableResultsTest.assertEquals((int)110, (int)scrollableResults.getRowNumber());
        scrollableResults.beforeFirst();
        int position = scrollableResults.getRowNumber();
        while (scrollableResults.next()) {
            int bookId = ++position + 20;
            ScrollableResultsTest.assertEquals((int)position, (int)scrollableResults.getRowNumber());
            AlternateBook book = (AlternateBook)scrollableResults.get()[0];
            ScrollableResultsTest.assertEquals((int)bookId, (int)book.getId());
            ScrollableResultsTest.assertEquals((String)("book about the number " + bookId), (String)book.getSummary());
            ScrollableResultsTest.assertTrue((boolean)this.sess.contains((Object)book));
        }
        ScrollableResultsTest.assertEquals((int)110, (int)position);
        scrollableResults.close();
        tx.commit();
    }

    public void testScrollingBackwards() {
        Transaction tx = this.sess.beginTransaction();
        TermQuery tq = new TermQuery(new Term("summary", "number"));
        Sort sort = new Sort(new SortField("id", 3));
        ScrollableResults scrollableResults = this.sess.createFullTextQuery((Query)tq, new Class[]{AlternateBook.class}).setSort(sort).setFetchSize(10).scroll();
        scrollableResults.beforeFirst();
        ScrollableResultsTest.assertEquals((int)-1, (int)scrollableResults.getRowNumber());
        ScrollableResultsTest.assertTrue((boolean)scrollableResults.last());
        int position = scrollableResults.getRowNumber();
        ScrollableResultsTest.assertEquals((int)323, (int)position);
        while (scrollableResults.previous()) {
            AlternateBook book = (AlternateBook)scrollableResults.get()[0];
            ScrollableResultsTest.assertEquals((int)(--position), (int)book.getId());
            ScrollableResultsTest.assertEquals((String)("book about the number " + position), (String)book.getSummary());
        }
        ScrollableResultsTest.assertEquals((int)0, (int)position);
        ScrollableResultsTest.assertEquals((int)-1, (int)scrollableResults.getRowNumber());
        scrollableResults.close();
        tx.commit();
    }

    public void testResultsAreManaged() {
        AlternateBook book;
        Transaction tx = this.sess.beginTransaction();
        TermQuery tq = new TermQuery(new Term("summary", "number"));
        Sort sort = new Sort(new SortField("id", 3));
        ScrollableResults scrollableResults = this.sess.createFullTextQuery((Query)tq, new Class[]{AlternateBook.class}).setSort(sort).setFetchSize(10).scroll();
        int position = -1;
        while (scrollableResults.next()) {
            book = (AlternateBook)scrollableResults.get()[0];
            ScrollableResultsTest.assertTrue((boolean)this.sess.contains((Object)book));
            if (++position % 3 != 0) continue;
            this.sess.evict((Object)book);
            ScrollableResultsTest.assertFalse((boolean)this.sess.contains((Object)book));
        }
        ScrollableResultsTest.assertEquals((int)323, (int)position);
        while (scrollableResults.previous()) {
            --position;
            book = (AlternateBook)scrollableResults.get()[0];
            ScrollableResultsTest.assertTrue((boolean)this.sess.contains((Object)book));
        }
        ScrollableResultsTest.assertEquals((int)-1, (int)position);
        this.sess.clear();
        while (scrollableResults.next()) {
            ++position;
            book = (AlternateBook)scrollableResults.get()[0];
            ScrollableResultsTest.assertTrue((boolean)this.sess.contains((Object)book));
        }
        ScrollableResultsTest.assertEquals((int)323, (int)position);
        tx.commit();
    }

    public void testScrollProjectionAndManaged() {
        Object[] objs;
        Transaction tx = this.sess.beginTransaction();
        TermQuery tq = new TermQuery(new Term("dept", "num"));
        Sort sort = new Sort(new SortField("id", 3));
        ScrollableResults scrollableResults = this.sess.createFullTextQuery((Query)tq, new Class[]{Employee.class}).setProjection(new String[]{"_hibernate_class", "__HSearch_id", "__HSearch_This", "lastname", "__HSearch_This"}).setFetchSize(10).setSort(sort).scroll();
        scrollableResults.last();
        ScrollableResultsTest.assertEquals((int)132, (int)scrollableResults.getRowNumber());
        scrollableResults.beforeFirst();
        ScrollableResultsTest.assertEquals((int)-1, (int)scrollableResults.getRowNumber());
        int position = scrollableResults.getRowNumber();
        while (scrollableResults.next()) {
            objs = scrollableResults.get();
            ScrollableResultsTest.assertEquals(Employee.class, (Object)objs[0]);
            ScrollableResultsTest.assertEquals((Object)(++position), (Object)objs[1]);
            ScrollableResultsTest.assertTrue((boolean)(objs[2] instanceof Employee));
            this.sess.contains(objs[2]);
            ScrollableResultsTest.assertEquals((Object)"Rossi", (Object)objs[3]);
            ScrollableResultsTest.assertTrue((boolean)(objs[4] instanceof Employee));
            this.sess.contains(objs[4]);
            ScrollableResultsTest.assertTrue((objs[2] == objs[4] ? 1 : 0) != 0);
            if (position % 3 != 0) continue;
            this.sess.evict(objs[2]);
        }
        ScrollableResultsTest.assertEquals((int)132, (int)position);
        while (scrollableResults.previous()) {
            --position;
            objs = scrollableResults.get();
            ScrollableResultsTest.assertTrue((boolean)(objs[2] instanceof Employee));
            this.sess.contains(objs[2]);
            ScrollableResultsTest.assertTrue((boolean)(objs[4] instanceof Employee));
            this.sess.contains(objs[4]);
            ScrollableResultsTest.assertTrue((objs[2] == objs[4] ? 1 : 0) != 0);
        }
        ScrollableResultsTest.assertEquals((int)-1, (int)position);
        scrollableResults.close();
        tx.commit();
    }
}

