/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.reader.functionality;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.store.Directory;
import org.hibernate.search.SearchException;
import org.hibernate.search.reader.ReaderProviderHelper;
import org.hibernate.search.reader.SharingBufferReaderProvider;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.RAMDirectoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestableSharingBufferReaderProvider
extends SharingBufferReaderProvider {
    private static final int NUM_DIRECTORY_PROVIDERS = 4;
    private final Vector<MockIndexReader> createdReadersHistory = new Vector(500);
    final Map<Directory, TestManipulatorPerDP> manipulators = new ConcurrentHashMap<Directory, TestManipulatorPerDP>();
    final List<DirectoryProvider> directoryProviders = Collections.synchronizedList(new ArrayList());

    public TestableSharingBufferReaderProvider() {
        for (int i = 0; i < 4; ++i) {
            TestManipulatorPerDP tm = new TestManipulatorPerDP(i);
            this.manipulators.put(tm.dp.getDirectory(), tm);
            this.directoryProviders.add(tm.dp);
        }
    }

    public boolean isReaderCurrent(MockIndexReader reader) {
        for (SharingBufferReaderProvider.PerDirectoryLatestReader latest : this.currentReaders.values()) {
            IndexReader latestReader = latest.current.reader;
            if (latestReader != reader) continue;
            return true;
        }
        return false;
    }

    protected IndexReader readerFactory(Directory directory) {
        TestManipulatorPerDP manipulatorPerDP = this.manipulators.get(directory);
        if (!manipulatorPerDP.isReaderCreated.compareAndSet(false, true)) {
            throw new IllegalStateException("IndexReader1 created twice");
        }
        return new MockIndexReader(manipulatorPerDP.isIndexReaderCurrent);
    }

    public void initialize(Properties props, BuildContext context) {
        try {
            for (Directory directory : this.manipulators.keySet()) {
                this.currentReaders.put(directory, new SharingBufferReaderProvider.PerDirectoryLatestReader((SharingBufferReaderProvider)this, directory));
            }
        }
        catch (IOException e) {
            throw new SearchException("Unable to open Lucene IndexReader", (Throwable)e);
        }
    }

    public boolean areAllOldReferencesGone() {
        int numExpectedActiveReaders;
        int numReferencesReaders = this.allReaders.size();
        return numReferencesReaders == (numExpectedActiveReaders = this.manipulators.size());
    }

    public List<MockIndexReader> getCreatedIndexReaders() {
        return this.createdReadersHistory;
    }

    public MockIndexReader getCurrentMockReaderPerDP(DirectoryProvider dp) {
        IndexReader[] indexReaders = ReaderProviderHelper.getSubReadersFromMultiReader((MultiReader)((MultiReader)super.openReader(new DirectoryProvider[]{dp})));
        if (indexReaders.length != 1) {
            throw new IllegalStateException("Expecting one reader");
        }
        return (MockIndexReader)indexReaders[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MockIndexReader
    extends IndexReader {
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final AtomicBoolean hasAlreadyBeenReOpened = new AtomicBoolean(false);
        private final AtomicBoolean isIndexReaderCurrent;

        MockIndexReader(AtomicBoolean isIndexReaderCurrent) {
            this.isIndexReaderCurrent = isIndexReaderCurrent;
            if (!isIndexReaderCurrent.compareAndSet(false, true)) {
                throw new IllegalStateException("Unnecessarily reopened");
            }
            TestableSharingBufferReaderProvider.this.createdReadersHistory.add(this);
        }

        public final boolean isClosed() {
            return this.closed.get();
        }

        protected void doClose() throws IOException {
            boolean okToClose = this.closed.compareAndSet(false, true);
            if (!okToClose) {
                throw new IllegalStateException("Attempt to close a closed IndexReader");
            }
            if (!this.hasAlreadyBeenReOpened.get()) {
                throw new IllegalStateException("Attempt to close the most current IndexReader");
            }
        }

        public synchronized IndexReader reopen() {
            if (this.isIndexReaderCurrent.get()) {
                return this;
            }
            if (this.hasAlreadyBeenReOpened.compareAndSet(false, true)) {
                return new MockIndexReader(this.isIndexReaderCurrent);
            }
            throw new IllegalStateException("Attempt to reopen an old IndexReader more than once");
        }

        protected void doDelete(int docNum) {
            throw new UnsupportedOperationException();
        }

        protected void doSetNorm(int doc, String field, byte value) {
            throw new UnsupportedOperationException();
        }

        protected void doUndeleteAll() {
            throw new UnsupportedOperationException();
        }

        public int docFreq(Term t) {
            throw new UnsupportedOperationException();
        }

        public Document document(int n, FieldSelector fieldSelector) {
            throw new UnsupportedOperationException();
        }

        public Collection getFieldNames(IndexReader.FieldOption fldOption) {
            throw new UnsupportedOperationException();
        }

        public TermFreqVector getTermFreqVector(int docNumber, String field) {
            throw new UnsupportedOperationException();
        }

        public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) {
            throw new UnsupportedOperationException();
        }

        public void getTermFreqVector(int docNumber, TermVectorMapper mapper) {
            throw new UnsupportedOperationException();
        }

        public TermFreqVector[] getTermFreqVectors(int docNumber) {
            throw new UnsupportedOperationException();
        }

        public boolean hasDeletions() {
            return false;
        }

        public boolean isDeleted(int n) {
            throw new UnsupportedOperationException();
        }

        public int maxDoc() {
            return 10;
        }

        public byte[] norms(String field) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void norms(String field, byte[] bytes, int offset) {
            throw new UnsupportedOperationException();
        }

        public int numDocs() {
            throw new UnsupportedOperationException();
        }

        public TermDocs termDocs() {
            throw new UnsupportedOperationException();
        }

        public TermPositions termPositions() {
            throw new UnsupportedOperationException();
        }

        public TermEnum terms() throws IOException {
            throw new UnsupportedOperationException();
        }

        public TermEnum terms(Term t) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected void doCommit(Map<String, String> commitUserData) {
            throw new UnsupportedOperationException();
        }

        protected void doCommit() {
            throw new UnsupportedOperationException();
        }
    }

    public static class TestManipulatorPerDP {
        private final AtomicBoolean isIndexReaderCurrent = new AtomicBoolean(false);
        private final AtomicBoolean isReaderCreated = new AtomicBoolean(false);
        private final DirectoryProvider dp = new RAMDirectoryProvider();

        public TestManipulatorPerDP(int seed) {
            this.dp.initialize("dp" + seed, new Properties(), null);
            this.dp.start();
        }

        public void setIndexChanged() {
            this.isIndexReaderCurrent.set(false);
        }
    }
}

