/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import java.io.Serializable;
import junit.framework.TestCase;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IdHashShardingStrategy;
import org.hibernate.search.store.RAMDirectoryProvider;

public class IdShardingStrategyTest
extends TestCase {
    private IdHashShardingStrategy shardStrategy;

    protected void setUp() throws Exception {
        this.shardStrategy = new IdHashShardingStrategy();
        this.shardStrategy.initialize(null, new DirectoryProvider[]{new RAMDirectoryProvider(), new RAMDirectoryProvider()});
    }

    public void testHashOverflow() {
        String key = String.valueOf(0x7FFFFFFE);
        IdShardingStrategyTest.assertTrue((key.hashCode() < 0 ? 1 : 0) != 0);
        this.assertAcceptableId(key);
    }

    private void assertAcceptableId(String id) {
        try {
            this.shardStrategy.getDirectoryProviderForAddition(null, (Serializable)((Object)id), id, null);
            this.shardStrategy.getDirectoryProvidersForDeletion(null, (Serializable)((Object)id), id);
        }
        catch (Exception e) {
            IdShardingStrategyTest.fail((String)("Couldn't get directory for id " + id));
        }
    }
}

