/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.worker;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.impl.FullTextSessionImpl;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.worker.Employee;
import org.hibernate.search.test.worker.Employer;
import org.hibernate.search.util.FileHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerTestCase
extends SearchTestCase {
    @Override
    protected void setUp() throws Exception {
        File[] files;
        File sub = this.getBaseIndexDir();
        sub.mkdir();
        for (File file : files = sub.listFiles()) {
            if (!file.isDirectory()) continue;
            FileHelper.delete((File)file);
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        File sub = this.getBaseIndexDir();
        FileHelper.delete((File)sub);
        WorkerTestCase.setCfg(null);
    }

    public void testConcurrency() throws Exception {
        int nThreads = 15;
        ExecutorService es = Executors.newFixedThreadPool(nThreads);
        Work work = new Work(this.getSessions());
        ReverseWork reverseWork = new ReverseWork(this.getSessions());
        long start = System.nanoTime();
        int iteration = 100;
        for (int i = 0; i < iteration; ++i) {
            es.execute(work);
            es.execute(reverseWork);
        }
        while (work.count.get() < iteration - 1) {
            Thread.sleep(20L);
        }
        this.getSessions().close();
        System.out.println(iteration + " iterations (8 tx per iteration) in " + nThreads + " threads: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        File sub = this.getBaseIndexDir();
        cfg.setProperty("hibernate.search.default.indexBase", sub.getAbsolutePath());
        cfg.setProperty("hibernate.search.Clock.directory_provider", "filesystem");
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
        cfg.setProperty("hibernate.show_sql", "false");
        cfg.setProperty("hibernate.format_sql", "false");
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Employee.class, Employer.class};
    }

    protected static class ReverseWork
    implements Runnable {
        private SessionFactory sf;

        public ReverseWork(SessionFactory sf) {
            this.sf = sf;
        }

        public void run() {
            org.hibernate.classic.Session s = this.sf.openSession();
            Transaction tx = s.beginTransaction();
            Employer er = new Employer();
            er.setName("RH");
            s.persist((Object)er);
            Employee ee = new Employee();
            ee.setName("Emmanuel");
            s.persist((Object)ee);
            tx.commit();
            s.close();
            s = this.sf.openSession();
            tx = s.beginTransaction();
            er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
            er.setName("RH2");
            ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
            ee.setName("Emmanuel2");
            tx.commit();
            s.close();
            s = this.sf.openSession();
            tx = s.beginTransaction();
            er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
            s.delete((Object)er);
            ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
            s.delete((Object)ee);
            tx.commit();
            s.close();
        }
    }

    protected static class Work
    implements Runnable {
        private SessionFactory sf;
        public AtomicInteger count = new AtomicInteger(0);

        public Work(SessionFactory sf) {
            this.sf = sf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            org.hibernate.classic.Session s = null;
            Transaction tx = null;
            try {
                Query query;
                s = this.sf.openSession();
                tx = s.beginTransaction();
                Employee ee = new Employee();
                ee.setName("Emmanuel");
                s.persist((Object)ee);
                Employer er = new Employer();
                er.setName("RH");
                s.persist((Object)er);
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                ee.setName("Emmanuel2");
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                er.setName("RH2");
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                FullTextSessionImpl fts = new FullTextSessionImpl((Session)s);
                QueryParser parser = new QueryParser(SearchTestCase.getTargetLuceneVersion(), "id", SearchTestCase.stopAnalyzer);
                try {
                    query = parser.parse("name:emmanuel2");
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                boolean results = fts.createFullTextQuery(query, new Class[0]).list().size() > 0;
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                s.delete((Object)ee);
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                s.delete((Object)er);
                tx.commit();
                s.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                this.count.incrementAndGet();
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    if (s != null && s.isOpen()) {
                        s.close();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

