/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class SimpleIndexingProgressMonitor
implements MassIndexerProgressMonitor {
    private static final Logger log = LoggerFactory.make();
    private final AtomicLong documentsDoneCounter = new AtomicLong();
    private final AtomicLong totalCounter = new AtomicLong();
    private volatile long startTime;

    public void entitiesLoaded(int size) {
    }

    public void documentsAdded(long increment) {
        long current = this.documentsDoneCounter.addAndGet(increment);
        if (current == increment) {
            this.startTime = System.nanoTime();
        }
        if (current % (long)this.getStatusMessagePeriod() == 0L) {
            this.printStatusMessage(this.startTime, this.totalCounter.get(), current);
        }
    }

    public void documentsBuilt(int number) {
    }

    public void addToTotalCount(long count) {
        this.totalCounter.addAndGet(count);
        log.info("Going to reindex {} entities", (Object)count);
    }

    public void indexingCompleted() {
        log.info("Reindexed {} entities", (Object)this.totalCounter.get());
    }

    protected int getStatusMessagePeriod() {
        return 50;
    }

    protected void printStatusMessage(long starttime, long totalTodoCount, long doneCount) {
        long elapsedMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - starttime);
        log.info("{} documents indexed in {} ms", (Object)doneCount, (Object)elapsedMs);
        float estimateSpeed = (float)doneCount * 1000.0f / (float)elapsedMs;
        float estimatePercentileComplete = (float)doneCount * 100.0f / (float)totalTodoCount;
        log.info("Indexing speed: {} documents/second; progress: {}%", (Object)Float.valueOf(estimateSpeed), (Object)Float.valueOf(estimatePercentileComplete));
    }
}

