/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.facet;

import org.hibernate.search.query.facet.FacetSortOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacetRequest {
    private final String name;
    private final String fieldName;
    private FacetSortOrder sort = FacetSortOrder.COUNT_DESC;
    private boolean includeZeroCounts = true;

    public FacetRequest(String name, String fieldName) {
        if (name == null) {
            throw new IllegalArgumentException("The request name name cannot be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("The field name cannot be null");
        }
        this.name = name;
        this.fieldName = fieldName;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setSort(FacetSortOrder sort) {
        this.sort = sort;
    }

    public FacetSortOrder getSort() {
        return this.sort;
    }

    public abstract Class<?> getFieldCacheType();

    public boolean includeZeroCounts() {
        return this.includeZeroCounts;
    }

    public void setIncludeZeroCounts(boolean includeZeroCounts) {
        this.includeZeroCounts = includeZeroCounts;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FacetRequest");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append(", sort=").append((Object)this.sort);
        sb.append(", includeZeroCounts=").append(this.includeZeroCounts);
        sb.append('}');
        return sb.toString();
    }
}

