/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.hibernate.search.query.fieldcache.FieldCacheCollector;
import org.hibernate.search.query.fieldcache.FieldLoadingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BigArrayFieldCacheCollectorImpl<T>
extends FieldCacheCollector<T> {
    private final T[] valuePerDocumentId;
    private int currentDocBase;
    private T[] currentCache;
    private final FieldLoadingStrategy<T> cacheLoadingStrategy;

    public BigArrayFieldCacheCollectorImpl(Collector delegate, FieldLoadingStrategy<T> cacheLoadingStrategy, T[] valueContainer) {
        super(delegate);
        this.cacheLoadingStrategy = cacheLoadingStrategy;
        this.valuePerDocumentId = valueContainer;
    }

    @Override
    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
        this.valuePerDocumentId[this.currentDocBase + doc] = this.cacheLoadingStrategy.collect(doc);
    }

    @Override
    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.currentDocBase = docBase;
        this.cacheLoadingStrategy.loadNewCacheValues(reader);
        this.delegate.setNextReader(reader, docBase);
    }

    @Override
    public T getValue(int docId) {
        return this.valuePerDocumentId[docId];
    }
}

