/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.hibernate.search.query.fieldcache.FieldLoadingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DoubleFieldLoadingStrategy
implements FieldLoadingStrategy<Double> {
    private final String fieldName;
    private double[] currentCache;

    public DoubleFieldLoadingStrategy(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void loadNewCacheValues(IndexReader reader) throws IOException {
        this.currentCache = FieldCache.DEFAULT.getDoubles(reader, this.fieldName);
    }

    @Override
    public Double collect(int relativeDocId) {
        return this.currentCache[relativeDocId];
    }
}

