/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache;

import org.apache.lucene.search.Collector;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.StringBridge;
import org.hibernate.search.query.fieldcache.BigArrayFieldCacheCollectorImpl;
import org.hibernate.search.query.fieldcache.FieldCacheCollector;
import org.hibernate.search.query.fieldcache.FieldCollectorType;
import org.hibernate.search.query.fieldcache.FieldLoadingStrategy;
import org.hibernate.search.query.fieldcache.MapFieldCacheCollectorImpl;
import org.hibernate.search.query.fieldcache.TwoWayTransformingFieldCacheCollector;

public class FieldCacheCollectorFactory {
    public static final FieldCacheCollectorFactory CLASS_TYPE_FIELDCACHE_COLLECTOR_FACTORY = new FieldCacheCollectorFactory("_hibernate_class", FieldCollectorType.STRING, new StringBridge());
    private static final int DEFAULT_IMPLEMENTATION_SWITCH_THRESHOLD = 100;
    private final String fieldName;
    private final FieldCollectorType type;
    private final int implementationSwitchThreshold;
    private final TwoWayStringBridge twoWayStringBridge;

    public FieldCacheCollectorFactory(String fieldName, FieldCollectorType type, TwoWayStringBridge twoWayStringBridge) {
        this(fieldName, type, twoWayStringBridge, 100);
    }

    public FieldCacheCollectorFactory(String fieldName, FieldCollectorType type, TwoWayStringBridge twoWayStringBridge, int implementationSwitchThreshold) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is mandatory");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is mandatory");
        }
        this.fieldName = fieldName;
        this.type = type;
        this.twoWayStringBridge = twoWayStringBridge;
        this.implementationSwitchThreshold = implementationSwitchThreshold;
    }

    public FieldCacheCollector createFieldCollector(Collector collector, int totalMaxDocs, int expectedMatchesCount) {
        FieldCacheCollector fieldCollector = this.createStringFieldCollector(collector, totalMaxDocs, expectedMatchesCount, this.type.createLoadingStrategy(this.fieldName));
        if (this.twoWayStringBridge != null) {
            return new TwoWayTransformingFieldCacheCollector(fieldCollector, this.twoWayStringBridge);
        }
        return fieldCollector;
    }

    private FieldCacheCollector createStringFieldCollector(Collector collector, int totalMaxDocs, int expectedMatchesCount, FieldLoadingStrategy stringDefaultLoader) {
        if (expectedMatchesCount > this.implementationSwitchThreshold) {
            return new BigArrayFieldCacheCollectorImpl<String>(collector, stringDefaultLoader, new String[totalMaxDocs]);
        }
        return new MapFieldCacheCollectorImpl(collector, stringDefaultLoader);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldCacheCollectorFactory other = (FieldCacheCollectorFactory)obj;
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        return this.type == other.type;
    }
}

