/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.hibernate.search.query.fieldcache.FieldLoadingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntFieldLoadingStrategy
implements FieldLoadingStrategy<Integer> {
    private final String fieldName;
    private int[] currentCache;

    public IntFieldLoadingStrategy(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void loadNewCacheValues(IndexReader reader) throws IOException {
        this.currentCache = FieldCache.DEFAULT.getInts(reader, this.fieldName);
    }

    @Override
    public Integer collect(int relativeDocId) {
        return this.currentCache[relativeDocId];
    }
}

