/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.hibernate.search.query.fieldcache.FieldCacheCollector;
import org.hibernate.search.query.fieldcache.FieldLoadingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MapFieldCacheCollectorImpl<T>
extends FieldCacheCollector<T> {
    private final FieldLoadingStrategy<T> cacheCollector;
    private final Map<Integer, T> valuePerDocumentId = new HashMap<Integer, T>();
    private int currentDocBase;

    public MapFieldCacheCollectorImpl(Collector delegate, FieldLoadingStrategy<T> collectorStrategy) {
        super(delegate);
        this.cacheCollector = collectorStrategy;
    }

    @Override
    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
        this.valuePerDocumentId.put(this.currentDocBase + doc, this.cacheCollector.collect(doc));
    }

    @Override
    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.currentDocBase = docBase;
        this.cacheCollector.loadNewCacheValues(reader);
        this.delegate.setNextReader(reader, docBase);
    }

    @Override
    public T getValue(int docId) {
        return this.valuePerDocumentId.get(docId);
    }
}

