/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.query.fieldcache.FieldCacheCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoWayTransformingFieldCacheCollector
extends FieldCacheCollector {
    private final TwoWayStringBridge stringBridge;
    private final FieldCacheCollector<String> privateDelegate;

    public TwoWayTransformingFieldCacheCollector(FieldCacheCollector<String> delegate, TwoWayStringBridge twoWayStringBridge) {
        super(delegate);
        this.privateDelegate = delegate;
        this.stringBridge = twoWayStringBridge;
    }

    @Override
    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
    }

    @Override
    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.delegate.setNextReader(reader, docBase);
    }

    public Object getValue(int docId) {
        String value = this.privateDelegate.getValue(docId);
        return this.stringBridge.stringToObject(value);
    }
}

