/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.Collections;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.AbstractLoader;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;
import org.hibernate.search.query.hibernate.impl.ObjectsInitializer;

public class QueryLoader
extends AbstractLoader {
    private Session session;
    private Class entityType;
    private SearchFactoryImplementor searchFactoryImplementor;
    private Criteria criteria;
    private boolean isExplicitCriteria;
    private TimeoutManager timeoutManager;
    private ObjectsInitializer objectsInitializer;

    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor, ObjectsInitializer objectsInitializer, TimeoutManager timeoutManager) {
        super.init(session, searchFactoryImplementor);
        this.session = session;
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.timeoutManager = timeoutManager;
        this.objectsInitializer = objectsInitializer;
    }

    public void setEntityType(Class entityType) {
        this.entityType = entityType;
    }

    public final Object executeLoad(EntityInfo entityInfo) {
        if (this.isExplicitCriteria) {
            this.load(new EntityInfo[]{entityInfo});
        }
        Object result = ObjectLoaderHelper.load(entityInfo, this.session);
        this.timeoutManager.isTimedOut();
        return result;
    }

    public final List executeLoad(EntityInfo ... entityInfos) {
        if (entityInfos.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (this.entityType == null) {
            throw new AssertionFailure("EntityType not defined");
        }
        if (this.criteria == null) {
            this.criteria = this.session.createCriteria(this.entityType);
        }
        this.objectsInitializer.initializeObjects(entityInfos, this.criteria, this.entityType, this.searchFactoryImplementor, this.timeoutManager, this.session);
        return ObjectLoaderHelper.returnAlreadyLoadedObjectsInCorrectOrder(entityInfos, this.session);
    }

    public void setCriteria(Criteria criteria) {
        this.isExplicitCriteria = criteria != null;
        this.criteria = criteria;
    }
}

