/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.configuration.IndexWriterSetting;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.test.SearchTestCase;

public abstract class ConfigurationReadTestCase
extends SearchTestCase {
    private SearchFactoryImplementor searchFactory;

    protected void setUp() throws Exception {
        super.setUp();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.searchFactory = (SearchFactoryImplementor)fullTextSession.getSearchFactory();
        fullTextSession.close();
    }

    protected final void assertValueIsDefault(Class testEntity, TransactionType parmGroup, IndexWriterSetting setting) {
        this.assertValueIsDefault(testEntity, 0, parmGroup, setting);
    }

    protected final void assertValueIsDefault(Class testEntity, int shard, TransactionType parmGroup, IndexWriterSetting setting) {
        boolean batch = this.isBatch(parmGroup);
        ConfigurationReadTestCase.assertNull((String)("shard:" + shard + " batch=" + batch + " setting:" + setting.getKey() + " : value was expected unset!"), (Object)this.getParameter(shard, batch, setting, testEntity));
    }

    protected final void assertValueIsSet(Class testEntity, TransactionType parmGroup, IndexWriterSetting setting, int expectedValue) {
        this.assertValueIsSet(testEntity, 0, parmGroup, setting, expectedValue);
    }

    protected final void assertValueIsSet(Class testEntity, int shard, TransactionType parmGroup, IndexWriterSetting setting, int expectedValue) {
        boolean batch = this.isBatch(parmGroup);
        ConfigurationReadTestCase.assertNotNull((String)("shard:" + shard + " batch=" + batch + " setting:" + setting.getKey()), (Object)this.getParameter(shard, batch, setting, testEntity));
        ConfigurationReadTestCase.assertEquals((String)("shard:" + shard + " batch=" + batch + " setting:" + setting.getKey()), (int)expectedValue, (int)this.getParameter(shard, batch, setting, testEntity));
    }

    protected final SearchFactoryImplementor getSearchFactory() {
        return this.searchFactory;
    }

    private boolean isBatch(TransactionType parmGroup) {
        return parmGroup == TransactionType.BATCH;
    }

    private Integer getParameter(int shard, boolean batch, IndexWriterSetting setting, Class testEntity) {
        if (batch) {
            return this.searchFactory.getIndexingParameters(this.searchFactory.getDirectoryProviders(testEntity)[shard]).getBatchIndexParameters().getCurrentValueFor(setting);
        }
        return this.searchFactory.getIndexingParameters(this.searchFactory.getDirectoryProviders(testEntity)[shard]).getTransactionIndexParameters().getCurrentValueFor(setting);
    }

    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.indexBase", this.getBaseIndexDir().getAbsolutePath());
    }

    public static void assertCfgIsInvalid(Configuration configuration, Class[] mapping) {
        try {
            for (Class annotated : mapping) {
                configuration.addAnnotatedClass(annotated);
            }
            configuration.setProperty("hibernate.search.default.directory_provider", "ram");
            configuration.buildSessionFactory();
            ConfigurationReadTestCase.fail();
        }
        catch (HibernateException e) {
            Throwable cause = e.getCause();
            ConfigurationReadTestCase.assertTrue((boolean)(cause instanceof SearchException));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TransactionType {
        TRANSACTION,
        BATCH;

    }
}

