/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.IOException;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.backend.configuration.IndexWriterSetting;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SerializationTestHelper;
import org.hibernate.search.test.configuration.ConfigurationReadTestCase;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexingParametersTest
extends ConfigurationReadTestCase {
    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.batch.ram_buffer_size", "1");
        cfg.setProperty("hibernate.search.default.transaction.use_compound_file", "false");
        cfg.setProperty("hibernate.search.default.batch.use_compound_file", "true");
        cfg.setProperty("hibernate.search.default.transaction.ram_buffer_size", "2");
        cfg.setProperty("hibernate.search.default.transaction.max_merge_docs", "9");
        cfg.setProperty("hibernate.search.default.transaction.max_buffered_docs", "11");
        cfg.setProperty("hibernate.search.Book.batch.max_merge_docs", "12");
        cfg.setProperty("hibernate.search.Book.transaction.use_compound_file", "false");
        cfg.setProperty("hibernate.search.Book.batch.merge_factor", "13");
        cfg.setProperty("hibernate.search.Book.indexwriter.batch.max_buffered_docs", "14");
        cfg.setProperty("hibernate.search.Book.indexwriter.transaction.ram_buffer_size", "4");
        cfg.setProperty("hibernate.search.Book.transaction.max_merge_docs", "15");
        cfg.setProperty("hibernate.search.Book.transaction.merge_factor", "16");
        cfg.setProperty("hibernate.search.Book.transaction.max_buffered_docs", "17");
        cfg.setProperty("hibernate.search.Documents.transaction.ram_buffer_size", "default");
        cfg.setProperty("hibernate.search.Documents.transaction.max_merge_docs", "5");
        cfg.setProperty("hibernate.search.Documents.transaction.merge_factor", "6");
        cfg.setProperty("hibernate.search.Documents.transaction.max_buffered_docs", "7");
        cfg.setProperty("hibernate.search.Documents.batch.max_merge_docs", "9");
        cfg.setProperty("hibernate.search.Documents.transaction.max_field_length", "7");
        cfg.setProperty("hibernate.search.Documents.batch.max_field_length", "9");
    }

    public void testDefaultIndexProviderParameters() {
        this.assertValueIsSet(Author.class, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.USE_COMPOUND_FILE, 1);
        this.assertValueIsSet(Author.class, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.RAM_BUFFER_SIZE, 2);
        this.assertValueIsSet(Author.class, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.MAX_MERGE_DOCS, 9);
        this.assertValueIsSet(Author.class, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.MAX_BUFFERED_DOCS, 11);
        this.assertValueIsSet(Author.class, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.MERGE_FACTOR, 100);
    }

    public void testBatchParametersGlobals() {
        this.assertValueIsSet(Author.class, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.RAM_BUFFER_SIZE, 1);
        this.assertValueIsDefault(Author.class, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.MAX_MERGE_DOCS);
        this.assertValueIsSet(Author.class, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.MAX_BUFFERED_DOCS, 1000);
    }

    public void testMaxFieldLength() {
        this.assertValueIsSet(Document.class, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.MAX_FIELD_LENGTH, 7);
        this.assertValueIsSet(Document.class, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.MAX_FIELD_LENGTH, 9);
    }

    public void testExplicitBatchParameters() {
        this.assertValueIsSet(Book.class, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.MAX_MERGE_DOCS, 12);
        this.assertValueIsSet(Book.class, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.MAX_BUFFERED_DOCS, 14);
        this.assertValueIsSet(Book.class, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.MERGE_FACTOR, 13);
        this.assertValueIsSet(Book.class, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.USE_COMPOUND_FILE, 0);
    }

    public void testInheritedBatchParameters() {
        this.assertValueIsSet(Book.class, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.RAM_BUFFER_SIZE, 1);
    }

    public void testTransactionParameters() {
        this.assertValueIsSet(Book.class, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.RAM_BUFFER_SIZE, 4);
        this.assertValueIsSet(Book.class, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.MAX_MERGE_DOCS, 15);
        this.assertValueIsSet(Book.class, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.MAX_BUFFERED_DOCS, 17);
        this.assertValueIsSet(Book.class, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.MERGE_FACTOR, 16);
    }

    public void testDefaultKeywordOverwritesInherited() {
        this.assertValueIsDefault(Document.class, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.RAM_BUFFER_SIZE);
        this.assertValueIsDefault(Document.class, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.RAM_BUFFER_SIZE);
    }

    public void testSerializability() throws IOException, ClassNotFoundException {
        LuceneIndexingParameters param = new LuceneIndexingParameters(new Properties());
        LuceneIndexingParameters paramCopy = (LuceneIndexingParameters)SerializationTestHelper.duplicateBySerialization(param);
        LuceneIndexingParametersTest.assertEquals((Object)param.getBatchIndexParameters(), (Object)paramCopy.getBatchIndexParameters());
        LuceneIndexingParametersTest.assertEquals((Object)param.getTransactionIndexParameters(), (Object)paramCopy.getTransactionIndexParameters());
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Author.class, Document.class};
    }
}

