/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.nested.containedIn;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.embedded.nested.containedIn.HelpItem;
import org.hibernate.search.test.embedded.nested.containedIn.HelpItemTag;
import org.hibernate.search.test.embedded.nested.containedIn.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedContainedInTest
extends SearchTestCase {
    public void testAddHelpItem() {
        this.openSession();
        String tagName = "animal";
        this.createHelpItem(tagName);
        this.doQuery(tagName);
        this.session.close();
    }

    public void testChangeTagName() {
        this.openSession();
        String tagName = "animal";
        this.createHelpItem(tagName);
        HelpItem check = this.doQuery(tagName);
        Tag tag = check.getTags().get(0).getTag();
        String newTagName = "automobile";
        tag.setName(newTagName);
        Transaction tx = this.session.beginTransaction();
        this.session.saveOrUpdate((Object)tag);
        tx.commit();
        this.doQuery(newTagName);
        this.session.close();
    }

    private void createHelpItem(String tagName) {
        Transaction tx = this.session.beginTransaction();
        HelpItem helpItem = new HelpItem();
        helpItem.setTitle("The quick brown fox jumps over the lazy dog.");
        Tag tag = new Tag();
        tag.setName(tagName);
        HelpItemTag helpItemTag = new HelpItemTag();
        helpItemTag.setHelpItem(helpItem);
        helpItemTag.setTag(tag);
        helpItem.getTags().add(helpItemTag);
        tag.getHelpItems().add(helpItemTag);
        this.session.save((Object)helpItem);
        this.session.save((Object)tag);
        this.session.save((Object)helpItemTag);
        tx.commit();
    }

    private HelpItem doQuery(String tagName) {
        Transaction tx = this.session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.session);
        TermQuery termQuery = new TermQuery(new Term("tags.tag.name", tagName));
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)termQuery, new Class[]{HelpItem.class});
        HelpItem check = (HelpItem)fullTextQuery.uniqueResult();
        NestedContainedInTest.assertNotNull((String)("No HelpItem with Tag '" + tagName + "' found in Lucene index."), (Object)check);
        NestedContainedInTest.assertTrue((boolean)check.getTags().get(0).getTag().getName().equals(tagName));
        tx.commit();
        return check;
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{HelpItem.class, HelpItemTag.class, Tag.class};
    }
}

