/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.util.Properties;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class JGroupsEnvironment {
    private static final Logger log;

    public static void initJGroupsProperties() {
        log.debug("JGroups environment setup");
    }

    static {
        String ip4Stack;
        log = LoggerFactory.make();
        Properties properties = System.getProperties();
        if (properties.containsKey(ip4Stack = "java.net.preferIPv4Stack")) {
            log.debug("Found explicit value for '" + ip4Stack + "' Using value: " + properties.get(ip4Stack));
        } else {
            log.debug("'" + ip4Stack + "' property not set. Setting it explicitly to 'true'");
            System.setProperty(ip4Stack, "true");
        }
        String bindAddress = "jgroups.bind_addr";
        if (properties.containsKey(bindAddress)) {
            log.debug("Found explicit value for '" + bindAddress + "' Using value: " + properties.get(bindAddress));
        } else {
            log.debug("'" + bindAddress + "' property not set. Setting it explicitly to '127.0.0.1'");
            System.setProperty("jgroups.bind_addr", "127.0.0.1");
        }
    }
}

