/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.engine.impl.HSQueryImpl;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSelection;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetManagerImpl
implements FacetManager {
    private final Map<String, FacetingRequestImpl> facetRequests = CollectionHelper.newHashMap();
    private final Map<String, FacetSelectionImpl> facetSelection = CollectionHelper.newHashMap();
    private Map<String, List<Facet>> facetResults;
    private Filter facetFilter;
    private final HSQueryImpl query;

    FacetManagerImpl(HSQueryImpl query) {
        this.query = query;
    }

    @Override
    public FacetManager enableFaceting(FacetingRequest facetingRequest) {
        this.facetRequests.put(facetingRequest.getFacetingName(), (FacetingRequestImpl)facetingRequest);
        this.queryHasChanged();
        return this;
    }

    @Override
    public void disableFaceting(String facetingName) {
        this.facetRequests.remove(facetingName);
        if (this.facetResults != null) {
            this.facetResults.remove(facetingName);
        }
        this.queryHasChanged();
    }

    @Override
    public List<Facet> getFacets(String facetingName) {
        if (this.facetRequests.isEmpty() || !this.facetRequests.containsKey(facetingName)) {
            return Collections.emptyList();
        }
        List<Facet> facets = null;
        if (this.facetResults != null) {
            facets = this.facetResults.get(facetingName);
        }
        if (facets != null) {
            return facets;
        }
        DocumentExtractor queryDocumentExtractor = this.query.queryDocumentExtractor();
        queryDocumentExtractor.close();
        if (this.facetResults == null) {
            return Collections.emptyList();
        }
        List<Facet> results = this.facetResults.get(facetingName);
        if (results != null) {
            return results;
        }
        return Collections.emptyList();
    }

    @Override
    public FacetSelection getFacetGroup(String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException("null is not a valid facet selection group name");
        }
        FacetSelectionImpl selection = this.facetSelection.get(groupName);
        if (selection == null) {
            selection = new FacetSelectionImpl();
            this.facetSelection.put(groupName, selection);
        }
        return selection;
    }

    Map<String, FacetingRequestImpl> getFacetRequests() {
        return this.facetRequests;
    }

    void setFacetResults(Map<String, List<Facet>> facetResults) {
        this.facetResults = facetResults;
    }

    void queryHasChanged() {
        this.facetFilter = null;
        this.facetResults = null;
        this.query.clearCachedResults();
    }

    Filter getFacetFilter() {
        if (this.facetFilter == null) {
            BooleanQuery boolQuery = new BooleanQuery();
            for (FacetSelectionImpl selection : this.facetSelection.values()) {
                if (selection.getFacetList().isEmpty()) continue;
                Query selectionGroupQuery = this.createSelectionGroupQuery(selection);
                boolQuery.add(selectionGroupQuery, BooleanClause.Occur.MUST);
            }
            if (boolQuery.getClauses().length > 0) {
                this.facetFilter = new QueryWrapperFilter((Query)boolQuery);
            }
        }
        return this.facetFilter;
    }

    private Query createSelectionGroupQuery(FacetSelectionImpl selection) {
        BooleanQuery orQuery = new BooleanQuery();
        for (Facet facet : selection.getFacetList()) {
            orQuery.add(facet.getFacetQuery(), BooleanClause.Occur.SHOULD);
        }
        return orQuery;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FacetSelectionImpl
    implements FacetSelection {
        private final List<Facet> facetList = CollectionHelper.newArrayList();

        FacetSelectionImpl() {
        }

        public List<Facet> getFacetList() {
            return this.facetList;
        }

        @Override
        public void selectFacets(Facet ... facets) {
            if (facets == null) {
                return;
            }
            this.facetList.addAll(Arrays.asList(facets));
            FacetManagerImpl.this.queryHasChanged();
        }

        @Override
        public List<Facet> getSelectedFacets() {
            return Collections.unmodifiableList(this.facetList);
        }

        @Override
        public void deselectFacets(Facet ... facets) {
            boolean hasChanged = this.facetList.removeAll(Arrays.asList(facets));
            if (hasChanged) {
                FacetManagerImpl.this.queryHasChanged();
            }
        }

        @Override
        public void clearSelectedFacets() {
            this.facetList.clear();
            FacetManagerImpl.this.queryHasChanged();
        }
    }
}

