/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.embedded.Country;
import org.hibernate.search.test.embedded.Owner;
import org.hibernate.search.test.embedded.Person;
import org.hibernate.search.test.embedded.Tower;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Indexed
public class Address {
    @Id
    @GeneratedValue
    @DocumentId
    private Long id;
    @Field(index=Index.TOKENIZED)
    private String street;
    @IndexedEmbedded(depth=1, prefix="ownedBy_", targetElement=Owner.class)
    @Target(value=Owner.class)
    private Person ownedBy;
    @OneToMany(mappedBy="address")
    @ContainedIn
    private Set<Tower> towers = new HashSet<Tower>();
    @ManyToOne(cascade={CascadeType.ALL})
    @IndexedEmbedded
    private Country country;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public Person getOwnedBy() {
        return this.ownedBy;
    }

    public void setOwnedBy(Person ownedBy) {
        this.ownedBy = ownedBy;
    }

    public Set<Tower> getTowers() {
        return this.towers;
    }

    public void setTowers(Set<Tower> towers) {
        this.towers = towers;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }
}

