/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.embedded.AbstractProduct;
import org.hibernate.search.test.embedded.Address;
import org.hibernate.search.test.embedded.Author;
import org.hibernate.search.test.embedded.Book;
import org.hibernate.search.test.embedded.Country;
import org.hibernate.search.test.embedded.NonIndexedEntity;
import org.hibernate.search.test.embedded.Order;
import org.hibernate.search.test.embedded.Owner;
import org.hibernate.search.test.embedded.Product;
import org.hibernate.search.test.embedded.ProductFeature;
import org.hibernate.search.test.embedded.State;
import org.hibernate.search.test.embedded.StateCandidate;
import org.hibernate.search.test.embedded.Tower;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedTest
extends SearchTestCase {
    public void testEmbeddedIndexing() throws Exception {
        Tower tower = new Tower();
        tower.setName("JBoss tower");
        Address a = new Address();
        a.setStreet("Tower place");
        a.getTowers().add(tower);
        tower.setAddress(a);
        Owner o = new Owner();
        o.setName("Atlanta Renting corp");
        a.setOwnedBy(o);
        o.setAddress(a);
        Country c = new Country();
        c.setName("France");
        a.setCountry(c);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)tower);
        tx.commit();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(EmbeddedTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("address.street:place");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        EmbeddedTest.assertEquals((String)"unable to find property in embedded", (int)1, (int)result.size());
        query = parser.parse("address.ownedBy_name:renting");
        result = session.createFullTextQuery(query, new Class[]{Tower.class}).list();
        EmbeddedTest.assertEquals((String)"unable to find property in embedded", (int)1, (int)result.size());
        query = parser.parse("address.id:" + a.getId().toString());
        result = session.createFullTextQuery(query, new Class[]{Tower.class}).list();
        EmbeddedTest.assertEquals((String)"unable to find property by id of embedded", (int)1, (int)result.size());
        query = parser.parse("address.country.name:" + a.getCountry().getName());
        result = session.createFullTextQuery(query, new Class[]{Tower.class}).list();
        EmbeddedTest.assertEquals((String)"unable to find property with 2 levels of embedded", (int)1, (int)result.size());
        s.clear();
        tx = s.beginTransaction();
        Address address = (Address)s.get(Address.class, (Serializable)a.getId());
        address.getOwnedBy().setName("Buckhead community");
        tx.commit();
        s.clear();
        session = Search.getFullTextSession((Session)s);
        query = parser.parse("address.ownedBy_name:buckhead");
        result = session.createFullTextQuery(query, new Class[]{Tower.class}).list();
        EmbeddedTest.assertEquals((String)"change in embedded not reflected in root index", (int)1, (int)result.size());
        s.clear();
        tx = s.beginTransaction();
        s.delete(s.get(Tower.class, (Serializable)tower.getId()));
        tx.commit();
        s.close();
    }

    public void testEmbeddedIndexingOneToMany() throws Exception {
        Country country = new Country();
        country.setName("Germany");
        ArrayList<State> states = new ArrayList<State>();
        State bayern = new State();
        bayern.setName("Bayern");
        State hessen = new State();
        hessen.setName("Hessen");
        State sachsen = new State();
        sachsen.setName("Sachsen");
        states.add(bayern);
        states.add(hessen);
        states.add(sachsen);
        country.setStates(states);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)country);
        tx.commit();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(EmbeddedTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("states.name:Hessen");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        EmbeddedTest.assertEquals((String)"unable to find property in embedded", (int)1, (int)result.size());
        s.close();
    }

    public void testContainedIn() throws Exception {
        Tower tower = new Tower();
        tower.setName("JBoss tower");
        Address a = new Address();
        a.setStreet("Tower place");
        a.getTowers().add(tower);
        tower.setAddress(a);
        Owner o = new Owner();
        o.setName("Atlanta Renting corp");
        a.setOwnedBy(o);
        o.setAddress(a);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)tower);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        Address address = (Address)s.get(Address.class, (Serializable)a.getId());
        address.setStreet("Peachtree Road NE");
        tx.commit();
        s.clear();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(EmbeddedTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("address.street:peachtree");
        List result = session.createFullTextQuery(query, new Class[]{Tower.class}).list();
        EmbeddedTest.assertEquals((String)"change in embedded not reflected in root index", (int)1, (int)result.size());
        s.clear();
        tx = s.beginTransaction();
        address = (Address)s.get(Address.class, (Serializable)a.getId());
        Tower tower1 = address.getTowers().iterator().next();
        tower1.setAddress(null);
        address.getTowers().remove(tower1);
        tx.commit();
        s.clear();
        session = Search.getFullTextSession((Session)s);
        query = parser.parse("address.street:peachtree");
        result = session.createFullTextQuery(query, new Class[]{Tower.class}).list();
        EmbeddedTest.assertEquals((String)"breaking link fails", (int)0, (int)result.size());
        tx = s.beginTransaction();
        s.delete(s.get(Tower.class, (Serializable)tower.getId()));
        tx.commit();
        s.close();
    }

    public void testIndexedEmbeddedAndCollections() throws Exception {
        Author a = new Author();
        a.setName("Voltaire");
        Author a2 = new Author();
        a2.setName("Victor Hugo");
        Author a3 = new Author();
        a3.setName("Moliere");
        Author a4 = new Author();
        a4.setName("Proust");
        Order o = new Order();
        o.setOrderNumber("ACVBNM");
        Order o2 = new Order();
        o2.setOrderNumber("ZERTYD");
        Product p1 = new Product();
        p1.setName("Candide");
        p1.getAuthors().add(a);
        p1.getAuthors().add(a2);
        Product p2 = new Product();
        p2.setName("Le malade imaginaire");
        p2.getAuthors().add(a3);
        p2.getOrders().put("Emmanuel", o);
        p2.getOrders().put("Gavin", o2);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)a);
        s.persist((Object)a2);
        s.persist((Object)a3);
        s.persist((Object)a4);
        s.persist((Object)o);
        s.persist((Object)o2);
        s.persist((Object)p1);
        s.persist((Object)p2);
        tx.commit();
        s.clear();
        FullTextSession session = Search.getFullTextSession((Session)s);
        tx = session.beginTransaction();
        MultiFieldQueryParser parser = new MultiFieldQueryParser(EmbeddedTest.getTargetLuceneVersion(), new String[]{"name", "authors.name"}, SearchTestCase.standardAnalyzer);
        Query query = parser.parse("Hugo");
        List result = session.createFullTextQuery(query, new Class[]{Product.class}).list();
        EmbeddedTest.assertEquals((String)"collection of embedded ignored", (int)1, (int)result.size());
        Product p = (Product)result.get(0);
        p.getAuthors().add(a4);
        query = new TermQuery(new Term("orders.orderNumber", "ZERTYD"));
        result = session.createFullTextQuery(query, new Class[]{Product.class}).list();
        EmbeddedTest.assertEquals((String)"collection of untokenized ignored", (int)1, (int)result.size());
        query = new TermQuery(new Term("orders.orderNumber", "ACVBNM"));
        result = session.createFullTextQuery(query, new Class[]{Product.class}).list();
        EmbeddedTest.assertEquals((String)"collection of untokenized ignored", (int)1, (int)result.size());
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        session = Search.getFullTextSession((Session)s);
        query = parser.parse("Proust");
        result = session.createFullTextQuery(query, new Class[]{Product.class}).list();
        EmbeddedTest.assertEquals((String)"update of collection of embedded ignored", (int)1, (int)result.size());
        s.delete(s.get(Product.class, (Serializable)p1.getId()));
        s.delete(s.get(Product.class, (Serializable)p2.getId()));
        tx.commit();
        s.close();
    }

    public void testEmbeddedObjectUpdate() throws Exception {
        State state = new State();
        state.setName("Bavaria");
        StateCandidate candiate = new StateCandidate();
        candiate.setName("Mueller");
        candiate.setState(state);
        state.setCandidate(candiate);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)candiate);
        tx.commit();
        s.clear();
        FullTextSession session = Search.getFullTextSession((Session)s);
        tx = session.beginTransaction();
        MultiFieldQueryParser parser = new MultiFieldQueryParser(EmbeddedTest.getTargetLuceneVersion(), new String[]{"name", "state.name"}, SearchTestCase.standardAnalyzer);
        Query query = parser.parse("Bavaria");
        List result = session.createFullTextQuery(query, new Class[]{StateCandidate.class}).list();
        EmbeddedTest.assertEquals((String)"IndexEmbedded ignored.", (int)1, (int)result.size());
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        state.setName("Hessen");
        state = (State)s.merge((Object)state);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        session = Search.getFullTextSession((Session)s);
        query = parser.parse("Hessen");
        result = session.createFullTextQuery(query, new Class[]{StateCandidate.class}).list();
        EmbeddedTest.assertEquals((String)"IndexEmbedded ignored.", (int)1, (int)result.size());
        tx.commit();
        s.clear();
        s.close();
    }

    public void testEmbeddedToManyInSuperslass() throws ParseException {
        ProductFeature f = new ProductFeature();
        f.setName("featurea");
        ProductFeature f2 = new ProductFeature();
        f2.setName("featureb");
        AbstractProduct p = new Book();
        p.setName("A Book");
        f.setProduct(p);
        p.getFeatures().add(f);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)p);
        tx.commit();
        s.clear();
        FullTextSession session = Search.getFullTextSession((Session)s);
        tx = session.beginTransaction();
        QueryParser parser = new QueryParser(EmbeddedTest.getTargetLuceneVersion(), "name", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("features.name:featurea");
        List result = session.createFullTextQuery(query, new Class[]{AbstractProduct.class}).list();
        EmbeddedTest.assertEquals((String)"collection of embedded ignored", (int)1, (int)result.size());
        p = (AbstractProduct)result.get(0);
        p.getFeatures().add(f2);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        tx.commit();
        s.clear();
        query = parser.parse("features.name:featureb");
        result = session.createFullTextQuery(query, new Class[]{AbstractProduct.class}).list();
        EmbeddedTest.assertEquals((String)"collection of embedded ignored", (int)1, (int)result.size());
        s.close();
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Tower.class, Address.class, Product.class, Order.class, Author.class, Country.class, State.class, StateCandidate.class, NonIndexedEntity.class, AbstractProduct.class, Book.class, ProductFeature.class};
    }
}

