/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.doubleinsert;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.test.embedded.doubleinsert.Contact;

@Entity
@Table(name="T_PHONE")
@Indexed
public class Phone
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="P_PHONE_ID")
    @DocumentId
    private long id;
    @Column(name="P_NUMBER")
    @Field(index=Index.TOKENIZED, store=Store.YES)
    private String number;
    @Column(name="P_TYPE")
    @Field(index=Index.TOKENIZED, store=Store.YES)
    private String type;
    @Column(name="P_CREATEDON")
    @Type(type="java.util.Date")
    private Date createdOn;
    @Column(name="P_LASTUPDATEDON")
    @Type(type="java.util.Date")
    private Date lastUpdatedOn;
    @ManyToOne
    @JoinColumn(name="C_CONTACT_ID")
    @IndexedEmbedded
    private Contact contact;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getType() {
        if (null == this.type || "".equals(this.type)) {
            return "N/A";
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        this.lastUpdatedOn = lastUpdatedOn;
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }
}

