/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.graph;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.test.embedded.graph.Event;
import org.hibernate.search.test.embedded.graph.ParentOfBirthEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Indexed
public class Person
implements Serializable {
    private Long id;
    private Set<ParentOfBirthEvent> parentOfBirthEvents;
    private Event birthEvent = new Event();
    private String name;

    public Person() {
        this.birthEvent.getChildren().add(this);
        this.parentOfBirthEvents = new HashSet<ParentOfBirthEvent>();
    }

    @DocumentId
    @Id
    @GeneratedValue
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ContainedIn
    @OneToMany(cascade={CascadeType.ALL})
    public Set<ParentOfBirthEvent> getParentOfBirthEvents() {
        return this.parentOfBirthEvents;
    }

    public void setParentOfBirthEvents(Set<ParentOfBirthEvent> parentOfBirthEvents) {
        this.parentOfBirthEvents = parentOfBirthEvents;
    }

    @IndexedEmbedded(depth=4)
    @ManyToOne(cascade={CascadeType.ALL}, optional=false)
    public Event getBirthEvent() {
        return this.birthEvent;
    }

    public void setBirthEvent(Event birthEvent) {
        this.birthEvent = birthEvent;
    }

    @Field(store=Store.YES)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

