/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jms.slave;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.broker.BrokerService;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.jms.master.JMSMasterTest;
import org.hibernate.search.test.jms.slave.SearchQueueChecker;
import org.hibernate.search.test.jms.slave.TShirt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSSlaveTest
extends SearchTestCase {
    private static final String QUEUE_NAME = "queue/searchtest";
    private static final String CONNECTION_FACTORY_NAME = "java:/ConnectionFactory";
    private BrokerService brokerService;
    private QueueSession queueSession;

    public void testMessageSend() throws Exception {
        this.registerMessageListener();
        SearchQueueChecker.reset();
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        TShirt ts = new TShirt();
        ts.setLogo("Boston");
        ts.setSize("XXL");
        TShirt ts2 = new TShirt();
        ts2.setLogo("Mapple leaves");
        ts2.setSize("L");
        s.persist((Object)ts);
        s.persist((Object)ts2);
        tx.commit();
        Thread.sleep(500L);
        JMSSlaveTest.assertEquals((int)1, (int)SearchQueueChecker.queues);
        JMSSlaveTest.assertEquals((int)2, (int)SearchQueueChecker.works);
        SearchQueueChecker.reset();
        s = this.openSession();
        tx = s.beginTransaction();
        ts = (TShirt)s.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId()));
        ts.setLogo("Peter pan");
        tx.commit();
        Thread.sleep(500L);
        JMSSlaveTest.assertEquals((int)1, (int)SearchQueueChecker.queues);
        JMSSlaveTest.assertEquals((int)2, (int)SearchQueueChecker.works);
        SearchQueueChecker.reset();
        s = this.openSession();
        tx = s.beginTransaction();
        s.delete(s.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId())));
        s.delete(s.get(TShirt.class, (Serializable)Integer.valueOf(ts2.getId())));
        tx.commit();
        Thread.sleep(500L);
        JMSSlaveTest.assertEquals((int)1, (int)SearchQueueChecker.queues);
        JMSSlaveTest.assertEquals((int)2, (int)SearchQueueChecker.works);
        s.close();
    }

    protected void setUp() throws Exception {
        this.brokerService = JMSMasterTest.createTestingBrokerService();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    private void registerMessageListener() throws Exception {
        MessageConsumer consumer = this.getQueueSession().createConsumer((Destination)this.getMessageQueue());
        consumer.setMessageListener((MessageListener)new SearchQueueChecker());
    }

    private Queue getMessageQueue() throws Exception {
        Context ctx = this.getJndiInitialContext();
        return (Queue)ctx.lookup(QUEUE_NAME);
    }

    private QueueSession getQueueSession() throws Exception {
        if (this.queueSession == null) {
            Context ctx = this.getJndiInitialContext();
            QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup(CONNECTION_FACTORY_NAME);
            QueueConnection conn = factory.createQueueConnection();
            conn.start();
            this.queueSession = conn.createQueueSession(false, 1);
        }
        return this.queueSession;
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.worker.backend", "jms");
        cfg.setProperty("hibernate.search.worker.jms.connection_factory", CONNECTION_FACTORY_NAME);
        cfg.setProperty("hibernate.search.worker.jms.queue", QUEUE_NAME);
        cfg.setProperty("hibernate.search.worker.jndi.class", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        cfg.setProperty("hibernate.search.worker.jndi.url", "vm://localhost");
        cfg.setProperty("hibernate.search.worker.jndi.connectionFactoryNames", "ConnectionFactory, java:/ConnectionFactory");
        cfg.setProperty("hibernate.search.worker.jndi.queue.queue/searchtest", "searchQueue");
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }

    private Context getJndiInitialContext() throws NamingException {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        props.setProperty("java.naming.provider.url", "vm://localhost");
        props.setProperty("connectionFactoryNames", "ConnectionFactory, java:/ConnectionFactory");
        props.setProperty("queue.queue/searchtest", "searchQueue");
        InitialContext ctx = new InitialContext(props);
        return ctx;
    }
}

