/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.hana;

import java.util.BitSet;
import java.util.List;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class HANASpatialFunction
extends StandardSQLFunction {
    private static final String AS_EWKB_SUFFIX = ".ST_AsEWKB()";
    private final BitSet argumentIsGeometryTypeMask = new BitSet();
    private final boolean staticFunction;

    public HANASpatialFunction(String name, boolean firstArgumentIsGeometryType) {
        super(name);
        this.argumentIsGeometryTypeMask.set(1, firstArgumentIsGeometryType);
        this.staticFunction = false;
    }

    public HANASpatialFunction(String name, boolean firstArgumentIsGeometryType, boolean staticFunction) {
        super(name);
        this.argumentIsGeometryTypeMask.set(staticFunction ? 0 : 1, firstArgumentIsGeometryType);
        this.staticFunction = staticFunction;
    }

    public HANASpatialFunction(String name, Type registeredType, boolean firstArgumentIsGeometryType) {
        super(name, registeredType);
        this.argumentIsGeometryTypeMask.set(1, firstArgumentIsGeometryType);
        this.staticFunction = false;
    }

    public HANASpatialFunction(String name, Type registeredType, boolean[] argumentIsGeometryTypeMask) {
        super(name, registeredType);
        for (int i = 0; i < argumentIsGeometryTypeMask.length; ++i) {
            this.argumentIsGeometryTypeMask.set(i + 1, argumentIsGeometryTypeMask[i]);
        }
        this.staticFunction = false;
    }

    public HANASpatialFunction(String name, Type registeredType, boolean firstArgumentIsGeometryType, boolean staticFunction) {
        super(name, registeredType);
        this.argumentIsGeometryTypeMask.set(staticFunction ? 0 : 1, firstArgumentIsGeometryType);
        this.staticFunction = staticFunction;
    }

    public String render(Type firstArgumentType, List arguments, SessionFactoryImplementor sessionFactory) {
        int firstArgumentIndex;
        if (arguments.size() == 0) {
            return this.getName() + "()";
        }
        StringBuilder buf = new StringBuilder();
        if (this.staticFunction) {
            buf.append(this.getName());
            firstArgumentIndex = 0;
        } else {
            buf.append(this.stripEWKBSuffix(arguments.get(0)));
            buf.append(".").append(this.getName());
            firstArgumentIndex = 1;
        }
        buf.append('(');
        for (int i = firstArgumentIndex; i < arguments.size(); ++i) {
            boolean parseFromWKB;
            Object argument = arguments.get(i);
            boolean bl = parseFromWKB = this.isGeometryArgument(i) && "?".equals(argument);
            if (parseFromWKB) {
                buf.append("ST_GeomFromEWKB(");
            }
            buf.append(this.stripEWKBSuffix(argument));
            if (parseFromWKB) {
                buf.append(")");
            }
            if (i >= arguments.size() - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        if (this.getType() == null) {
            buf.append(AS_EWKB_SUFFIX);
        }
        return buf.toString();
    }

    private Object stripEWKBSuffix(Object argument) {
        if (argument instanceof String && ((String)argument).endsWith(AS_EWKB_SUFFIX)) {
            String argumentString = (String)argument;
            return argumentString.substring(0, argumentString.length() - AS_EWKB_SUFFIX.length());
        }
        return argument;
    }

    private boolean isGeometryArgument(int idx) {
        return this.argumentIsGeometryTypeMask.size() > idx && this.argumentIsGeometryTypeMask.get(idx);
    }
}

