/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.junit.functional;

import java.util.Iterator;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Mappings;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;

public class ExecutionEnvironment {
    public static final Dialect DIALECT = Dialect.getDialect();
    private final Settings settings;
    private Configuration configuration;
    private SessionFactory sessionFactory;
    private boolean allowRebuild;
    static /* synthetic */ Class class$org$hibernate$junit$functional$ExecutionEnvironment;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;

    public ExecutionEnvironment(Settings settings) {
        this.settings = settings;
    }

    public boolean isAllowRebuild() {
        return this.allowRebuild;
    }

    public void setAllowRebuild(boolean allowRebuild) {
        this.allowRebuild = allowRebuild;
    }

    public Dialect getDialect() {
        return DIALECT;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void initialize() {
        if (this.sessionFactory != null) {
            throw new IllegalStateException("attempt to initialize already initialized ExecutionEnvironment");
        }
        if (!this.settings.appliesTo(this.getDialect())) {
            return;
        }
        Configuration configuration = new Configuration();
        configuration.setProperty("hibernate.cache.provider_class", "org.hibernate.cache.HashtableCacheProvider");
        this.settings.configure(configuration);
        this.applyMappings(configuration);
        this.applyCacheSettings(configuration);
        if (this.settings.createSchema()) {
            configuration.setProperty("hibernate.hbm2ddl.auto", "create-drop");
        }
        configuration.setProperty("hibernate.dialect", this.getDialect().getClass().getName());
        configuration.buildMappings();
        this.settings.afterConfigurationBuilt(configuration.createMappings(), this.getDialect());
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        this.configuration = configuration;
        this.sessionFactory = sessionFactory;
        this.settings.afterSessionFactoryBuilt((SessionFactoryImplementor)sessionFactory);
    }

    private void applyMappings(Configuration configuration) {
        String[] mappings = this.settings.getMappings();
        for (int i = 0; i < mappings.length; ++i) {
            configuration.addResource(this.settings.getBaseForMappings() + mappings[i], (class$org$hibernate$junit$functional$ExecutionEnvironment == null ? ExecutionEnvironment.class$("org.hibernate.junit.functional.ExecutionEnvironment") : class$org$hibernate$junit$functional$ExecutionEnvironment).getClassLoader());
        }
    }

    private void applyCacheSettings(Configuration configuration) {
        if (this.settings.getCacheConcurrencyStrategy() != null) {
            Iterator iter = configuration.getClassMappings();
            while (iter.hasNext()) {
                PersistentClass clazz = (PersistentClass)iter.next();
                Iterator props = clazz.getPropertyClosureIterator();
                boolean hasLob = false;
                while (props.hasNext()) {
                    Property prop = (Property)props.next();
                    if (!prop.getValue().isSimpleValue()) continue;
                    String type = ((SimpleValue)prop.getValue()).getTypeName();
                    if ("blob".equals(type) || "clob".equals(type)) {
                        hasLob = true;
                    }
                    if (!(class$java$sql$Blob == null ? ExecutionEnvironment.class$("java.sql.Blob") : class$java$sql$Blob).getName().equals(type) && !(class$java$sql$Clob == null ? ExecutionEnvironment.class$("java.sql.Clob") : class$java$sql$Clob).getName().equals(type)) continue;
                    hasLob = true;
                }
                if (hasLob || clazz.isInherited() || !this.settings.overrideCacheStrategy()) continue;
                configuration.setCacheConcurrencyStrategy(clazz.getEntityName(), this.settings.getCacheConcurrencyStrategy());
            }
            iter = configuration.getCollectionMappings();
            while (iter.hasNext()) {
                Collection coll = (Collection)iter.next();
                configuration.setCollectionCacheConcurrencyStrategy(coll.getRole(), this.settings.getCacheConcurrencyStrategy());
            }
        }
    }

    public void rebuild() {
        if (!this.allowRebuild) {
            return;
        }
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        this.sessionFactory = this.configuration.buildSessionFactory();
        this.settings.afterSessionFactoryBuilt((SessionFactoryImplementor)this.sessionFactory);
    }

    public void complete() {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        this.configuration = null;
    }

    public static interface Settings {
        public String[] getMappings();

        public String getBaseForMappings();

        public boolean createSchema();

        public boolean recreateSchemaAfterFailure();

        public void configure(Configuration var1);

        public boolean overrideCacheStrategy();

        public String getCacheConcurrencyStrategy();

        public void afterSessionFactoryBuilt(SessionFactoryImplementor var1);

        public void afterConfigurationBuilt(Mappings var1, Dialect var2);

        public boolean appliesTo(Dialect var1);
    }
}

