/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit;

import org.hibernate.testing.junit.UnitTestCase;

public abstract class AbstractClassLoaderIsolatedTestCase
extends UnitTestCase {
    private ClassLoader parentLoader;
    private ClassLoader isolatedLoader;

    public AbstractClassLoaderIsolatedTestCase(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.parentLoader = Thread.currentThread().getContextClassLoader();
        this.isolatedLoader = this.buildIsolatedClassLoader(this.parentLoader);
        Thread.currentThread().setContextClassLoader(this.isolatedLoader);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Thread.currentThread().setContextClassLoader(this.parentLoader);
        this.releaseIsolatedClassLoader(this.isolatedLoader);
        this.parentLoader = null;
        this.isolatedLoader = null;
    }

    protected abstract ClassLoader buildIsolatedClassLoader(ClassLoader var1);

    protected abstract void releaseIsolatedClassLoader(ClassLoader var1);
}

