/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.tm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.service.spi.UnknownUnwrapTypeException;
import org.hibernate.test.common.ConnectionProviderBuilder;
import org.hibernate.testing.tm.SimpleJtaTransactionImpl;
import org.hibernate.testing.tm.SimpleJtaTransactionManagerImpl;

public class ConnectionProviderImpl
implements ConnectionProvider {
    private static ConnectionProvider actualConnectionProvider = ConnectionProviderBuilder.buildConnectionProvider();
    private boolean isTransactional;

    public static ConnectionProvider getActualConnectionProvider() {
        return actualConnectionProvider;
    }

    public void configure(Properties props) throws HibernateException {
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProviderImpl.class.isAssignableFrom(unwrapType) || ConnectionProvider.class.isAssignableFrom(unwrapType) || ConnectionProviderImpl.getActualConnectionProvider().getClass().isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProviderImpl.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (ConnectionProvider.class.isAssignableFrom(unwrapType) || ConnectionProviderImpl.getActualConnectionProvider().getClass().isAssignableFrom(unwrapType)) {
            return (T)ConnectionProviderImpl.getActualConnectionProvider();
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public Connection getConnection() throws SQLException {
        SimpleJtaTransactionImpl currentTransaction = SimpleJtaTransactionManagerImpl.getInstance().getCurrentTransaction();
        if (currentTransaction == null) {
            this.isTransactional = false;
            return actualConnectionProvider.getConnection();
        }
        this.isTransactional = true;
        Connection connection = currentTransaction.getEnlistedConnection();
        if (connection == null) {
            connection = actualConnectionProvider.getConnection();
            currentTransaction.enlistConnection(connection);
        }
        return connection;
    }

    public void closeConnection(Connection conn) throws SQLException {
        if (!this.isTransactional) {
            conn.close();
        }
    }

    public void close() throws HibernateException {
        if (actualConnectionProvider instanceof Stoppable) {
            ((Stoppable)actualConnectionProvider).stop();
        }
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }
}

