/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jta;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.internal.arjuna.objectstore.VolatileStore;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.UserTransaction;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.hibernate.cfg.Environment;
import org.hibernate.service.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.hibernate.service.jta.platform.internal.JBossStandAloneJtaPlatform;

public class TestingJtaBootstrap {
    public static final TestingJtaBootstrap INSTANCE = new TestingJtaBootstrap();
    private javax.transaction.TransactionManager transactionManager;
    private javax.transaction.UserTransaction userTransaction;
    private DataSource dataSource;

    private TestingJtaBootstrap() {
        ((ObjectStoreEnvironmentBean)BeanPopulator.getDefaultInstance(ObjectStoreEnvironmentBean.class)).setObjectStoreType(VolatileStore.class.getName());
        ((ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"communicationStore")).setObjectStoreType(VolatileStore.class.getName());
        ((ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"stateStore")).setObjectStoreType(VolatileStore.class.getName());
        this.transactionManager = TransactionManager.transactionManager();
        this.userTransaction = UserTransaction.userTransaction();
        Properties environmentProperties = Environment.getProperties();
        StandardXADataSource dataSource = new StandardXADataSource();
        dataSource.setTransactionManager(TransactionManager.transactionManager());
        try {
            dataSource.setDriverName(environmentProperties.getProperty("hibernate.connection.driver_class"));
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to set DataSource JDBC driver name", e);
        }
        dataSource.setUrl(environmentProperties.getProperty("hibernate.connection.url"));
        dataSource.setUser(environmentProperties.getProperty("hibernate.connection.username"));
        dataSource.setPassword(environmentProperties.getProperty("hibernate.connection.password"));
        String isolationString = environmentProperties.getProperty("hibernate.connection.isolation");
        if (isolationString != null) {
            dataSource.setTransactionIsolation(Integer.valueOf(isolationString).intValue());
        }
        this.dataSource = dataSource;
    }

    public javax.transaction.TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public javax.transaction.UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public static void prepare(Map configValues) {
        configValues.put("hibernate.transaction.jta.platform", new JBossStandAloneJtaPlatform());
        configValues.put("hibernate.connection.provider_class", DatasourceConnectionProviderImpl.class.getName());
        configValues.put("hibernate.connection.datasource", INSTANCE.getDataSource());
    }
}

