/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.Timestamper;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Settings;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.testing.cache.BaseGeneralDataRegion;
import org.hibernate.testing.cache.CollectionRegionImpl;
import org.hibernate.testing.cache.EntityRegionImpl;
import org.hibernate.testing.cache.NaturalIdRegionImpl;
import org.jboss.logging.Logger;

public class CachingRegionFactory
implements RegionFactory {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)CachingRegionFactory.class.getName());
    private Settings settings;

    public CachingRegionFactory() {
        LOG.warn((Object)"CachingRegionFactory should be only used for testing.");
    }

    public CachingRegionFactory(Properties properties) {
        LOG.warn((Object)"CachingRegionFactory should be only used for testing.");
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        this.settings = settings;
    }

    public void stop() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.NONSTRICT_READ_WRITE;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new EntityRegionImpl(regionName, metadata, this.settings);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new NaturalIdRegionImpl(regionName, metadata, this.settings);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new CollectionRegionImpl(regionName, metadata, this.settings);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new QueryResultsRegionImpl(regionName);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new TimestampsRegionImpl(regionName);
    }

    private static class TimestampsRegionImpl
    extends BaseGeneralDataRegion
    implements TimestampsRegion {
        TimestampsRegionImpl(String name) {
            super(name);
        }
    }

    private static class QueryResultsRegionImpl
    extends BaseGeneralDataRegion
    implements QueryResultsRegion {
        QueryResultsRegionImpl(String name) {
            super(name);
        }
    }
}

