/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jta;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.internal.arjuna.objectstore.VolatileStore;
import com.arjuna.ats.jta.UserTransaction;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.hibernate.cfg.Environment;
import org.hibernate.service.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.hibernate.service.jta.platform.internal.AbstractJtaPlatform;

public class TestingJtaBootstrap {
    public static final TestingJtaBootstrap INSTANCE = new TestingJtaBootstrap();
    private TransactionManager transactionManager;
    private javax.transaction.UserTransaction userTransaction;
    private DataSource dataSource;

    private TestingJtaBootstrap() {
        ((ObjectStoreEnvironmentBean)BeanPopulator.getDefaultInstance(ObjectStoreEnvironmentBean.class)).setObjectStoreType(VolatileStore.class.getName());
        ((ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"communicationStore")).setObjectStoreType(VolatileStore.class.getName());
        ((ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"stateStore")).setObjectStoreType(VolatileStore.class.getName());
        this.transactionManager = com.arjuna.ats.jta.TransactionManager.transactionManager();
        this.userTransaction = UserTransaction.userTransaction();
        Properties environmentProperties = Environment.getProperties();
        JtaAwareDataSource dataSource = new JtaAwareDataSource();
        dataSource.setTransactionManager(this.transactionManager);
        try {
            dataSource.setDriverName(environmentProperties.getProperty("hibernate.connection.driver_class"));
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to set DataSource JDBC driver name", e);
        }
        dataSource.setUrl(environmentProperties.getProperty("hibernate.connection.url"));
        dataSource.setUser(environmentProperties.getProperty("hibernate.connection.username"));
        dataSource.setPassword(environmentProperties.getProperty("hibernate.connection.password"));
        environmentProperties.remove("hibernate.connection.username");
        environmentProperties.remove("hibernate.connection.password");
        String isolationString = environmentProperties.getProperty("hibernate.connection.isolation");
        if (isolationString != null) {
            dataSource.setTransactionIsolation(Integer.valueOf(isolationString));
        }
        this.dataSource = dataSource;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public static void prepare(Map configValues) {
        configValues.put("hibernate.transaction.jta.platform", TestingJtaPlatformImpl.INSTANCE);
        configValues.put("hibernate.connection.provider_class", JtaAwareDataSourceConnectionProvider.class.getName());
        configValues.put("hibernate.connection.datasource", INSTANCE.getDataSource());
        configValues.put("javax.persistence.transactionType", "JTA");
    }

    public static void tryCommit() throws Exception {
        if (TestingJtaBootstrap.INSTANCE.transactionManager.getStatus() == 1) {
            TestingJtaBootstrap.INSTANCE.transactionManager.rollback();
        } else {
            TestingJtaBootstrap.INSTANCE.transactionManager.commit();
        }
    }

    public static class JtaAwareDataSourceConnectionProvider
    extends DatasourceConnectionProviderImpl {
        public static final JtaAwareDataSourceConnectionProvider INSTANCE = new JtaAwareDataSourceConnectionProvider();

        public Connection getConnection() throws SQLException {
            return INSTANCE.dataSource.getConnection();
        }
    }

    public static class TestingJtaPlatformImpl
    extends AbstractJtaPlatform {
        public static final TestingJtaPlatformImpl INSTANCE = new TestingJtaPlatformImpl();

        protected TransactionManager locateTransactionManager() {
            return INSTANCE.transactionManager;
        }

        protected javax.transaction.UserTransaction locateUserTransaction() {
            return INSTANCE.userTransaction;
        }
    }

    public static class JtaAwareDataSource
    extends StandardXADataSource {
        public Connection getConnection() throws SQLException {
            if (this.getTransactionManager() == null) {
                this.setTransactionManager(INSTANCE.transactionManager);
            }
            Connection connection = this.getXAConnection().getConnection();
            connection.setAutoCommit(false);
            return connection;
        }

        public <T> T unwrap(Class<T> iface) throws SQLException {
            return null;
        }

        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }
    }
}

