/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.testing.DialectCheck;
import org.hibernate.testing.FailureExpected;
import org.hibernate.testing.RequiresDialect;
import org.hibernate.testing.RequiresDialectFeature;
import org.hibernate.testing.RequiresDialects;
import org.hibernate.testing.Skip;
import org.hibernate.testing.SkipForDialect;
import org.hibernate.testing.SkipForDialects;
import org.hibernate.testing.junit4.AfterClassCallbackHandler;
import org.hibernate.testing.junit4.BeforeClassCallbackHandler;
import org.hibernate.testing.junit4.ExtendedFrameworkMethod;
import org.hibernate.testing.junit4.FailureExpectedHandler;
import org.hibernate.testing.junit4.Helper;
import org.hibernate.testing.junit4.TestClassMetadata;
import org.jboss.logging.Logger;
import org.junit.Ignore;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class CustomRunner
extends BlockJUnit4ClassRunner {
    private static final Logger log = Logger.getLogger(CustomRunner.class);
    private TestClassMetadata testClassMetadata;
    private Boolean isAllTestsIgnored = null;
    private Object testInstance;
    private List<FrameworkMethod> computedTestMethods;
    private static Dialect dialect = CustomRunner.determineDialect();

    public CustomRunner(Class<?> clazz) throws InitializationError, NoTestsRemainException {
        super(clazz);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        this.testClassMetadata = new TestClassMetadata(this.getTestClass().getJavaClass());
        this.testClassMetadata.validate(errors);
    }

    public TestClassMetadata getTestClassMetadata() {
        return this.testClassMetadata;
    }

    private boolean isAllTestsIgnored() {
        if (this.isAllTestsIgnored == null) {
            if (this.computeTestMethods().isEmpty()) {
                this.isAllTestsIgnored = true;
            } else {
                this.isAllTestsIgnored = true;
                for (FrameworkMethod method : this.computeTestMethods()) {
                    Ignore ignore = (Ignore)method.getAnnotation(Ignore.class);
                    if (ignore != null) continue;
                    this.isAllTestsIgnored = false;
                    break;
                }
            }
        }
        return this.isAllTestsIgnored;
    }

    protected Statement withBeforeClasses(Statement statement) {
        if (this.isAllTestsIgnored()) {
            return super.withBeforeClasses(statement);
        }
        return new BeforeClassCallbackHandler(this, super.withBeforeClasses(statement));
    }

    protected Statement withAfterClasses(Statement statement) {
        if (this.isAllTestsIgnored()) {
            return super.withAfterClasses(statement);
        }
        return new AfterClassCallbackHandler(this, super.withAfterClasses(statement));
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Statement originalMethodBlock = super.methodBlock(method);
        ExtendedFrameworkMethod extendedFrameworkMethod = (ExtendedFrameworkMethod)method;
        return new FailureExpectedHandler(originalMethodBlock, this.testClassMetadata, extendedFrameworkMethod, this.testInstance);
    }

    protected Object getTestInstance() throws Exception {
        if (this.testInstance == null) {
            this.testInstance = super.createTest();
        }
        return this.testInstance;
    }

    protected Object createTest() throws Exception {
        return this.getTestInstance();
    }

    protected List<FrameworkMethod> computeTestMethods() {
        if (this.computedTestMethods == null) {
            this.computedTestMethods = this.doComputation();
            this.sortMethods(this.computedTestMethods);
        }
        return this.computedTestMethods;
    }

    protected void sortMethods(List<FrameworkMethod> computedTestMethods) {
        if (CollectionHelper.isEmpty(computedTestMethods)) {
            return;
        }
        Collections.sort(computedTestMethods, new Comparator<FrameworkMethod>(){

            @Override
            public int compare(FrameworkMethod o1, FrameworkMethod o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    protected List<FrameworkMethod> doComputation() {
        List methods = super.computeTestMethods();
        ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>();
        boolean doValidation = Boolean.getBoolean("hibernate.test.validatefailureexpected");
        int testCount = 0;
        for (FrameworkMethod frameworkMethod : methods) {
            FailureExpected failureExpected = Helper.locateAnnotation(FailureExpected.class, frameworkMethod, this.getTestClass());
            Ignore virtualIgnore = failureExpected != null && !doValidation ? new IgnoreImpl(Helper.extractIgnoreMessage(failureExpected, frameworkMethod)) : this.convertSkipToIgnore(frameworkMethod);
            log.trace((Object)("adding test " + Helper.extractTestName(frameworkMethod) + " [#" + ++testCount + "]"));
            result.add(new ExtendedFrameworkMethod(frameworkMethod, virtualIgnore, failureExpected));
        }
        return result;
    }

    private static Dialect determineDialect() {
        try {
            return Dialect.getDialect();
        }
        catch (Exception e) {
            return new Dialect(){};
        }
    }

    protected Ignore convertSkipToIgnore(FrameworkMethod frameworkMethod) {
        Skip skip = Helper.locateAnnotation(Skip.class, frameworkMethod, this.getTestClass());
        if (skip != null && this.isMatch(skip.condition())) {
            return this.buildIgnore(skip);
        }
        for (SkipForDialect skipForDialectAnn : Helper.collectAnnotations(SkipForDialect.class, SkipForDialects.class, frameworkMethod, this.getTestClass())) {
            Class<? extends Dialect>[] arr$ = skipForDialectAnn.value();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Class<? extends Dialect> dialectClass = arr$[i$];
                if (!(skipForDialectAnn.strictMatching() ? dialectClass.equals(dialect.getClass()) : dialectClass.isInstance(dialect))) continue;
                return this.buildIgnore(skipForDialectAnn);
            }
        }
        for (RequiresDialect requiresDialectAnn : Helper.collectAnnotations(RequiresDialect.class, RequiresDialects.class, frameworkMethod, this.getTestClass())) {
            boolean foundMatch = false;
            for (Class<? extends Dialect> dialectClass : requiresDialectAnn.value()) {
                boolean bl = foundMatch = requiresDialectAnn.strictMatching() ? dialectClass.equals(dialect.getClass()) : dialectClass.isInstance(dialect);
                if (foundMatch) break;
            }
            if (foundMatch) continue;
            return this.buildIgnore(requiresDialectAnn);
        }
        RequiresDialectFeature requiresDialectFeatureAnn = Helper.locateAnnotation(RequiresDialectFeature.class, frameworkMethod, this.getTestClass());
        if (requiresDialectFeatureAnn != null) {
            try {
                boolean foundMatch = false;
                for (Class<? extends DialectCheck> checkClass : requiresDialectFeatureAnn.value()) {
                    foundMatch = checkClass.newInstance().isMatch(dialect);
                    if (foundMatch) continue;
                    return this.buildIgnore(requiresDialectFeatureAnn);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate DialectCheck", e);
            }
        }
        return null;
    }

    private Ignore buildIgnore(Skip skip) {
        return new IgnoreImpl("@Skip : " + skip.message());
    }

    private Ignore buildIgnore(SkipForDialect skip) {
        return this.buildIgnore("@SkipForDialect match", skip.comment(), skip.jiraKey());
    }

    private Ignore buildIgnore(String reason, String comment, String jiraKey) {
        StringBuilder buffer = new StringBuilder(reason);
        if (StringHelper.isNotEmpty((String)comment)) {
            buffer.append("; ").append(comment);
        }
        if (StringHelper.isNotEmpty((String)jiraKey)) {
            buffer.append(" (").append(jiraKey).append(')');
        }
        return new IgnoreImpl(buffer.toString());
    }

    private Ignore buildIgnore(RequiresDialect requiresDialect) {
        return this.buildIgnore("@RequiresDialect non-match", requiresDialect.comment(), requiresDialect.jiraKey());
    }

    private Ignore buildIgnore(RequiresDialectFeature requiresDialectFeature) {
        return this.buildIgnore("@RequiresDialectFeature non-match", requiresDialectFeature.comment(), requiresDialectFeature.jiraKey());
    }

    private boolean isMatch(Class<? extends Skip.Matcher> condition) {
        try {
            Skip.Matcher matcher = condition.newInstance();
            return matcher.isMatch();
        }
        catch (Exception e) {
            throw new MatcherInstantiationException(condition, e);
        }
    }

    private static class MatcherInstantiationException
    extends RuntimeException {
        private MatcherInstantiationException(Class<? extends Skip.Matcher> matcherClass, Throwable cause) {
            super("Unable to instantiate specified Matcher [" + matcherClass.getName(), cause);
        }
    }

    public static class IgnoreImpl
    implements Ignore {
        private final String value;

        public IgnoreImpl(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public Class<? extends Annotation> annotationType() {
            return Ignore.class;
        }
    }
}

