/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.testing.cache.BaseRegion;
import org.jboss.logging.Logger;

class BaseGeneralDataRegion
extends BaseRegion
implements GeneralDataRegion {
    private static final Logger LOG = Logger.getLogger((String)BaseGeneralDataRegion.class.getName());

    BaseGeneralDataRegion(String name) {
        super(name);
    }

    public Object get(SessionImplementor session, Object key) throws CacheException {
        LOG.debugf("Cache[%s] lookup : key[%s]", (Object)this.getName(), key);
        if (key == null) {
            return null;
        }
        Object result = this.cache.get(key);
        if (result != null) {
            LOG.debugf("Cache[%s] hit: %s", (Object)this.getName(), key);
        }
        return result;
    }

    public void put(SessionImplementor session, Object key, Object value) throws CacheException {
        LOG.debugf("Caching[%s] : [%s] -> [%s]", (Object)this.getName(), key, value);
        if (key == null || value == null) {
            LOG.debug((Object)"Key or Value is null");
            return;
        }
        this.cache.put(key, value);
    }

    public void evict(Object key) throws CacheException {
        LOG.debugf("Evicting[%s]: %s", (Object)this.getName(), key);
        if (key == null) {
            LOG.debug((Object)"Key is null");
            return;
        }
        this.cache.remove(key);
    }

    public void evictAll() throws CacheException {
        LOG.debugf("evict cache[%s]", (Object)this.getName());
        this.cache.clear();
    }
}

