/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import java.util.Comparator;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.testing.cache.AbstractReadWriteAccessStrategy;
import org.hibernate.testing.cache.BaseGeneralDataRegion;
import org.hibernate.testing.cache.EntityRegionImpl;

class ReadWriteEntityRegionAccessStrategy
extends AbstractReadWriteAccessStrategy
implements EntityRegionAccessStrategy {
    private final EntityRegionImpl region;

    ReadWriteEntityRegionAccessStrategy(EntityRegionImpl region) {
        this.region = region;
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        return false;
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        try {
            this.writeLock.lock();
            AbstractReadWriteAccessStrategy.Lockable item = (AbstractReadWriteAccessStrategy.Lockable)this.region.get(session, key);
            if (item == null) {
                this.region.put(session, key, new AbstractReadWriteAccessStrategy.Item(value, version, this.region.nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        try {
            this.writeLock.lock();
            AbstractReadWriteAccessStrategy.Lockable item = (AbstractReadWriteAccessStrategy.Lockable)this.region.get(session, key);
            if (item != null && item.isUnlockable(lock)) {
                AbstractReadWriteAccessStrategy.Lock lockItem = (AbstractReadWriteAccessStrategy.Lock)item;
                if (lockItem.wasLockedConcurrently()) {
                    this.decrementLock(session, key, lockItem);
                    boolean bl = false;
                    return bl;
                }
                this.region.put(session, key, new AbstractReadWriteAccessStrategy.Item(value, currentVersion, this.region.nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            this.handleLockExpiry(session, key, item);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    protected BaseGeneralDataRegion getInternalRegion() {
        return this.region;
    }

    @Override
    protected boolean isDefaultMinimalPutOverride() {
        return this.region.getSettings().isMinimalPutsEnabled();
    }

    @Override
    Comparator getVersionComparator() {
        return this.region.getCacheDataDescription().getVersionComparator();
    }

    public EntityRegion getRegion() {
        return this.region;
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.region.getRegionFactory().getCacheKeysFactory().createEntityKey(id, persister, factory, tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return this.region.getRegionFactory().getCacheKeysFactory().getEntityId(cacheKey);
    }
}

