/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.transaction;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class TransactionUtil {
    public static <T> T doInJPA(Supplier<EntityManagerFactory> factorySupplier, JPATransactionFunction<T> function) {
        T result = null;
        EntityManager entityManager = null;
        EntityTransaction txn = null;
        try {
            entityManager = factorySupplier.get().createEntityManager();
            function.beforeTransactionCompletion();
            txn = entityManager.getTransaction();
            txn.begin();
            result = (T)function.apply(entityManager);
            txn.commit();
        }
        catch (Throwable e) {
            if (txn != null && txn.isActive()) {
                txn.rollback();
            }
            throw e;
        }
        finally {
            function.afterTransactionCompletion();
            if (entityManager != null) {
                entityManager.close();
            }
        }
        return result;
    }

    public static void doInJPA(Supplier<EntityManagerFactory> factorySupplier, JPATransactionVoidFunction function) {
        EntityManager entityManager = null;
        EntityTransaction txn = null;
        try {
            entityManager = factorySupplier.get().createEntityManager();
            function.beforeTransactionCompletion();
            txn = entityManager.getTransaction();
            txn.begin();
            function.accept(entityManager);
            txn.commit();
        }
        catch (Throwable e) {
            if (txn != null && txn.isActive()) {
                txn.rollback();
            }
            throw e;
        }
        finally {
            function.afterTransactionCompletion();
            if (entityManager != null) {
                entityManager.close();
            }
        }
    }

    public static <T> T doInHibernate(Supplier<SessionFactory> factorySupplier, HibernateTransactionFunction<T> function) {
        T result = null;
        Session session = null;
        Transaction txn = null;
        try {
            session = factorySupplier.get().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            result = (T)function.apply(session);
            txn.commit();
        }
        catch (Throwable e) {
            if (txn != null) {
                txn.rollback();
            }
            throw e;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
        return result;
    }

    public static void doInHibernate(Supplier<SessionFactory> factorySupplier, HibernateTransactionConsumer function) {
        Session session = null;
        Transaction txn = null;
        try {
            session = factorySupplier.get().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            function.accept(session);
            txn.commit();
        }
        catch (Throwable e) {
            if (txn != null) {
                txn.rollback();
            }
            throw e;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
    }

    public static <T> T doInHibernateSessionBuilder(Supplier<SessionBuilder> sessionBuilderSupplier, HibernateTransactionFunction<T> function) {
        T result = null;
        Session session = null;
        Transaction txn = null;
        try {
            session = sessionBuilderSupplier.get().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            result = (T)function.apply(session);
            txn.commit();
        }
        catch (Throwable e) {
            if (txn != null) {
                txn.rollback();
            }
            throw e;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
        return result;
    }

    public static void doInHibernateSessionBuilder(Supplier<SessionBuilder> sessionBuilderSupplier, HibernateTransactionConsumer function) {
        Session session = null;
        Transaction txn = null;
        try {
            session = sessionBuilderSupplier.get().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            function.accept(session);
            txn.commit();
        }
        catch (Throwable e) {
            if (txn != null) {
                txn.rollback();
            }
            throw e;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
    }

    @FunctionalInterface
    public static interface JPATransactionVoidFunction
    extends Consumer<EntityManager> {
        default public void beforeTransactionCompletion() {
        }

        default public void afterTransactionCompletion() {
        }
    }

    @FunctionalInterface
    public static interface JPATransactionFunction<T>
    extends Function<EntityManager, T> {
        default public void beforeTransactionCompletion() {
        }

        default public void afterTransactionCompletion() {
        }
    }

    @FunctionalInterface
    public static interface HibernateTransactionConsumer
    extends Consumer<Session> {
        default public void beforeTransactionCompletion() {
        }

        default public void afterTransactionCompletion() {
        }
    }

    @FunctionalInterface
    public static interface HibernateTransactionFunction<T>
    extends Function<Session, T> {
        default public void beforeTransactionCompletion() {
        }

        default public void afterTransactionCompletion() {
        }
    }
}

