/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mvn;

import java.io.File;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.hibernate.mvn.AbstractHbm2xMojo;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.hbm2x.DAOExporter;

@Mojo(name="hbm2dao", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateDaoMojo
extends AbstractHbm2xMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-sources/")
    private File outputDirectory;
    @Parameter(defaultValue="false")
    private boolean ejb3;
    @Parameter(defaultValue="false")
    private boolean jdk5;
    @Parameter
    private String templatePath;

    @Override
    protected void executeExporter(MetadataDescriptor metadataDescriptor) {
        DAOExporter daoExporter = new DAOExporter();
        daoExporter.setMetadataDescriptor(metadataDescriptor);
        daoExporter.setOutputDirectory(this.outputDirectory);
        if (this.templatePath != null) {
            this.getLog().info((CharSequence)("Setting template path to: " + this.templatePath));
            daoExporter.setTemplatePath(new String[]{this.templatePath});
        }
        daoExporter.getProperties().setProperty("ejb3", String.valueOf(this.ejb3));
        daoExporter.getProperties().setProperty("jdk5", String.valueOf(this.jdk5));
        this.getLog().info((CharSequence)("Starting DAO export to directory: " + this.outputDirectory + "..."));
        daoExporter.start();
    }
}

