/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.query.sql.NativeSQLQueryCollectionReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryJoinReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryRootReturn;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.pojo.SkipBackRefPropertyIterator;
import org.hibernate.tool.hbm2x.visitor.EntityNameFromValueVisitor;
import org.hibernate.tool.hbm2x.visitor.HBMTagForPersistentClassVisitor;
import org.hibernate.tool.hbm2x.visitor.HBMTagForValueVisitor;

public class Cfg2HbmTool {
    static /* synthetic */ Class class$org$hibernate$persister$entity$SingleTableEntityPersister;
    static /* synthetic */ Class class$org$hibernate$persister$entity$JoinedSubclassEntityPersister;
    static /* synthetic */ Class class$org$hibernate$persister$entity$UnionSubclassEntityPersister;

    static Properties getFilteredIdentifierGeneratorProperties(Properties properties) {
        if (properties != null) {
            Properties fProp = new Properties();
            Iterator<Object> itr = properties.keySet().iterator();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                if (key.startsWith("target_") || key.equals("identifier_normalizer")) continue;
                fProp.put(key, properties.get(key));
            }
            return fProp;
        }
        return null;
    }

    public String getTag(PersistentClass pc) {
        return (String)pc.accept(HBMTagForPersistentClassVisitor.INSTANCE);
    }

    public String getTag(Property property) {
        PersistentClass persistentClass = property.getPersistentClass();
        if (persistentClass != null && persistentClass.getVersion() == property) {
            String typeName = ((SimpleValue)property.getValue()).getTypeName();
            if ("timestamp".equals(typeName) || "dbtimestamp".equals(typeName)) {
                return "timestamp";
            }
            return "version";
        }
        String toolTag = (String)property.getValue().accept((ValueVisitor)HBMTagForValueVisitor.INSTANCE);
        if ("component".equals(toolTag) && "embedded".equals(property.getPropertyAccessorName())) {
            toolTag = "properties";
        }
        return toolTag;
    }

    public String getCollectionElementTag(Property property) {
        Value value = property.getValue();
        if (this.isOneToMany(value)) {
            return "one-to-many";
        }
        if (this.isManyToMany(value)) {
            return "many-to-many";
        }
        if (this.isManyToAny(value)) {
            return "many-to-any";
        }
        if (((Collection)value).getElement() instanceof Component) {
            return "composite";
        }
        return "element";
    }

    public boolean isUnsavedValue(Property property) {
        SimpleValue sv = (SimpleValue)property.getValue();
        return sv.getNullValue() != null && !"undefined".equals(sv.getNullValue());
    }

    public String getUnsavedValue(Property property) {
        return ((SimpleValue)property.getValue()).getNullValue();
    }

    public boolean isIdentifierGeneratorProperties(Property property) {
        Properties val = this.getIdentifierGeneratorProperties(property);
        return val != null;
    }

    public Properties getIdentifierGeneratorProperties(Property property) {
        return ((SimpleValue)property.getValue()).getIdentifierGeneratorProperties();
    }

    public Set getFilteredIdentifierGeneratorKeySet(Property property) {
        return Cfg2HbmTool.getFilteredIdentifierGeneratorProperties(this.getIdentifierGeneratorProperties(property)).keySet();
    }

    public boolean isOneToMany(Property property) {
        return this.isOneToMany(property.getValue());
    }

    public boolean isOneToMany(Value value) {
        if (value instanceof Collection) {
            return ((Collection)value).isOneToMany();
        }
        return value instanceof OneToMany;
    }

    public boolean isManyToMany(Property property) {
        return this.isManyToMany(property.getValue());
    }

    public boolean isManyToMany(Value value) {
        return value instanceof Collection && ((Collection)value).getElement() instanceof ManyToOne;
    }

    public boolean isCollection(Property property) {
        return property.getValue() instanceof Collection;
    }

    public boolean isOneToManyCollection(Property property) {
        return this.isCollection(property) && ((Collection)property.getValue()).isOneToMany();
    }

    public boolean isSimpleValue(Property property) {
        return property.getValue() instanceof SimpleValue;
    }

    public boolean isManyToOne(Property property) {
        return this.isManyToOne(property.getValue());
    }

    public boolean isManyToAny(Property property) {
        return this.isManyToAny(property.getValue());
    }

    public boolean isManyToAny(Value value) {
        return value instanceof Collection && ((Collection)value).getElement() instanceof Any;
    }

    public boolean isManyToOne(Value value) {
        return value instanceof ManyToOne;
    }

    public boolean isOneToOne(Property property) {
        return property.getValue() instanceof OneToOne;
    }

    public boolean isTemporalValue(Property property) {
        if (property.getValue() instanceof SimpleValue) {
            String typeName = ((SimpleValue)property.getValue()).getTypeName();
            if ("date".equals(typeName) || "java.sql.Date".equals(typeName)) {
                return true;
            }
            if ("timestamp".equals(typeName) || "java.sql.Timestamp".equals(typeName)) {
                return true;
            }
            if ("time".equals(typeName) || "java.sql.Time".equals(typeName)) {
                return true;
            }
        }
        return false;
    }

    public boolean isNamedQueries(Configuration cfg) {
        Map nqry = cfg.getNamedQueries();
        return nqry != null && !nqry.isEmpty();
    }

    public boolean isNamedSQLQueries(Configuration cfg) {
        Map nsqlqry = cfg.getNamedSQLQueries();
        return nsqlqry != null && !nsqlqry.isEmpty();
    }

    public String getCollectionLazy(Collection value) {
        return value.isExtraLazy() ? "extra" : Boolean.toString(value.isLazy());
    }

    public String getNamedSQLReturnTag(NativeSQLQueryReturn sqlret) {
        String retVal = "return";
        if (this.isNamedSQLReturnRole(sqlret)) {
            retVal = "return-join";
        } else if (this.isNamedSQLReturnCollection(sqlret)) {
            retVal = "load-collection";
        }
        return retVal;
    }

    public String getNamedSQLReturnProperty(NativeSQLQueryJoinReturn o) {
        return o.getOwnerAlias() + "." + o.getOwnerProperty();
    }

    public String getNamedSQLReturnRole(NativeSQLQueryCollectionReturn o) {
        return o.getOwnerEntityName() + "." + o.getOwnerProperty();
    }

    public boolean isNamedSQLReturnRoot(NativeSQLQueryReturn sqlret) {
        return sqlret instanceof NativeSQLQueryRootReturn;
    }

    public boolean isNamedSQLReturnCollection(NativeSQLQueryReturn sqlret) {
        return sqlret instanceof NativeSQLQueryCollectionReturn;
    }

    public boolean isNamedSQLReturnRole(NativeSQLQueryReturn sqlret) {
        return sqlret instanceof NativeSQLQueryJoinReturn;
    }

    public boolean isFilterDefinitions(Configuration cfg) {
        Map filterdefs = cfg.getFilterDefinitions();
        return filterdefs != null && !filterdefs.isEmpty();
    }

    public boolean isClassLevelOptimisticLockMode(PersistentClass pc) {
        return pc.getOptimisticLockMode() != 0;
    }

    public String getClassLevelOptimisticLockMode(PersistentClass pc) {
        int oMode = pc.getOptimisticLockMode();
        if (oMode == 1) {
            return "dirty";
        }
        if (oMode == 2) {
            return "all";
        }
        if (oMode == -1) {
            return "none";
        }
        return "version";
    }

    public boolean hasFetchMode(Property property) {
        String fetch = this.getFetchMode(property);
        return fetch != null && !"default".equals(fetch);
    }

    public String getFetchMode(Property property) {
        FetchMode fetchMode = property.getValue().getFetchMode();
        return fetchMode == null ? null : fetchMode.toString().toLowerCase();
    }

    public Formula getFormulaForProperty(Property prop) {
        Iterator iter = prop.getValue().getColumnIterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Formula)) continue;
            return (Formula)o;
        }
        return null;
    }

    public String columnAttributes(Column col) {
        return this.columnAttributes(col, false);
    }

    public String columnAttributes(Column column, boolean isPrimaryKeyColumn) {
        StringBuffer sb = new StringBuffer();
        if (column.getPrecision() != 19) {
            sb.append("precision=\"").append(column.getPrecision()).append("\" ");
        }
        if (column.getScale() != 2) {
            sb.append("scale=\"").append(column.getScale()).append("\" ");
        } else if (column.getLength() != 255) {
            sb.append("length=\"").append(column.getLength()).append("\" ");
        }
        if (!isPrimaryKeyColumn) {
            if (!column.isNullable()) {
                sb.append("not-null=\"true\" ");
            }
            if (column.isUnique()) {
                sb.append("unique=\"true\" ");
            }
        }
        if (column.getSqlType() != null) {
            sb.append("sql-type=\"");
            sb.append(column.getSqlType());
            sb.append("\" ");
        }
        return sb.toString();
    }

    public String getClassName(PersistentClass pc) {
        if (pc.hasPojoRepresentation()) {
            return pc.getClassName();
        }
        throw new ExporterException(pc + " does not have a pojo rep.");
    }

    public String getClassName(OneToMany om) {
        return om.getAssociatedClass().getClassName();
    }

    public String getProxyInterfaceName(PersistentClass pc) {
        if (pc.hasPojoRepresentation()) {
            return pc.getProxyInterfaceName();
        }
        throw new ExporterException(pc + " does not have a pojo rep.");
    }

    public boolean isImportData(Configuration cfg) {
        return !cfg.getImports().isEmpty();
    }

    public boolean needsDiscriminatorElement(PersistentClass clazz) {
        return clazz instanceof RootClass && clazz.getDiscriminator() != null;
    }

    public boolean needsDiscriminator(PersistentClass clazz) {
        return clazz instanceof Subclass && !(clazz instanceof UnionSubclass) && !(clazz instanceof JoinedSubclass);
    }

    public boolean needsTable(PersistentClass clazz) {
        Boolean accept = (Boolean)clazz.accept(new PersistentClassVisitor(){

            public Object accept(Subclass subclass) {
                return Boolean.FALSE;
            }

            public Object accept(JoinedSubclass subclass) {
                return Boolean.TRUE;
            }

            public Object accept(SingleTableSubclass subclass) {
                return Boolean.FALSE;
            }

            public Object accept(UnionSubclass subclass) {
                return Boolean.TRUE;
            }

            public Object accept(RootClass class1) {
                return Boolean.TRUE;
            }
        });
        return accept;
    }

    public boolean isSubclass(PersistentClass clazz) {
        return clazz instanceof Subclass;
    }

    public boolean isJoinedSubclass(PersistentClass clazz) {
        return clazz instanceof JoinedSubclass;
    }

    public boolean hasCustomEntityPersister(PersistentClass clazz) {
        Class entityPersisterClass = clazz.getEntityPersisterClass();
        if (entityPersisterClass == null) {
            return false;
        }
        String name = entityPersisterClass.getName();
        Boolean object = (Boolean)clazz.accept((PersistentClassVisitor)new HasEntityPersisterVisitor(name));
        return object;
    }

    public String getHibernateTypeName(Property p) {
        return (String)p.getValue().accept((ValueVisitor)new EntityNameFromValueVisitor());
    }

    public String getSafeHibernateTypeName(Property p) {
        return (String)p.getValue().accept((ValueVisitor)new EntityNameFromValueVisitor(false));
    }

    public Iterator getProperties(Component v) {
        return new SkipBackRefPropertyIterator(v.getPropertyIterator());
    }

    public Iterator getProperties(PersistentClass pc) {
        return new SkipBackRefPropertyIterator(pc.getUnjoinedPropertyIterator());
    }

    private final class HasEntityPersisterVisitor
    implements PersistentClassVisitor {
        private final String name;

        private HasEntityPersisterVisitor(String name) {
            this.name = name;
        }

        public Object accept(Subclass subclass) {
            return this.bool(!(class$org$hibernate$persister$entity$SingleTableEntityPersister == null ? (class$org$hibernate$persister$entity$SingleTableEntityPersister = Cfg2HbmTool.class$("org.hibernate.persister.entity.SingleTableEntityPersister")) : class$org$hibernate$persister$entity$SingleTableEntityPersister).getName().equals(this.name));
        }

        private Object bool(boolean b) {
            return b;
        }

        public Object accept(JoinedSubclass subclass) {
            return this.bool(!(class$org$hibernate$persister$entity$JoinedSubclassEntityPersister == null ? (class$org$hibernate$persister$entity$JoinedSubclassEntityPersister = Cfg2HbmTool.class$("org.hibernate.persister.entity.JoinedSubclassEntityPersister")) : class$org$hibernate$persister$entity$JoinedSubclassEntityPersister).getName().equals(this.name));
        }

        public Object accept(SingleTableSubclass subclass) {
            return this.bool(!(class$org$hibernate$persister$entity$SingleTableEntityPersister == null ? (class$org$hibernate$persister$entity$SingleTableEntityPersister = Cfg2HbmTool.class$("org.hibernate.persister.entity.SingleTableEntityPersister")) : class$org$hibernate$persister$entity$SingleTableEntityPersister).getName().equals(this.name));
        }

        public Object accept(UnionSubclass subclass) {
            return this.bool(!(class$org$hibernate$persister$entity$UnionSubclassEntityPersister == null ? (class$org$hibernate$persister$entity$UnionSubclassEntityPersister = Cfg2HbmTool.class$("org.hibernate.persister.entity.UnionSubclassEntityPersister")) : class$org$hibernate$persister$entity$UnionSubclassEntityPersister).getName().equals(this.name));
        }

        public Object accept(RootClass class1) {
            return this.bool(!(class$org$hibernate$persister$entity$SingleTableEntityPersister == null ? (class$org$hibernate$persister$entity$SingleTableEntityPersister = Cfg2HbmTool.class$("org.hibernate.persister.entity.SingleTableEntityPersister")) : class$org$hibernate$persister$entity$SingleTableEntityPersister).getName().equals(this.name));
        }
    }
}

