/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.cglib.core.KeyFactory;
import org.apache.commons.collections.MultiMap;
import org.dom4j.Document;
import org.hibernate.MappingException;
import org.hibernate.cfg.reveng.AssociationInfo;
import org.hibernate.cfg.reveng.DelegatingReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.MetaAttributeBinder;
import org.hibernate.cfg.reveng.OverrideBinder;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.SQLTypeMapping;
import org.hibernate.cfg.reveng.SchemaSelection;
import org.hibernate.cfg.reveng.TableFilter;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.Table;
import org.hibernate.util.StringHelper;
import org.hibernate.util.XMLHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class OverrideRepository {
    private static final Logger log = Logger.getLogger(OverrideRepository.class.getName());
    private final transient XMLHelper xmlHelper = new XMLHelper();
    private final transient EntityResolver entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
    private final Map typeMappings = new HashMap();
    private final List tableFilters = new ArrayList();
    private final List tables = new ArrayList();
    private final Map foreignKeys = new HashMap();
    private final Map typeForColumn = new HashMap();
    private final Map propertyNameForColumn = new HashMap();
    private final Map identifierStrategyForTable = new HashMap();
    private final Map identifierPropertiesForTable = new HashMap();
    private final Map primaryKeyColumnsForTable = new HashMap();
    private final Set excludedColumns;
    private final Map tableToClassName;
    private final List schemaSelections;
    private final Map propertyNameForPrimaryKey = new HashMap();
    private final Map compositeIdNameForTable;
    private final Map foreignKeyToOneName;
    private final Map foreignKeyToInverseName;
    private final Map foreignKeyInverseExclude;
    private final Map foreignKeyToOneExclude;
    private final Map foreignKeyToEntityInfo;
    private final Map foreignKeyToInverseEntityInfo;
    private final Map tableMetaAttributes;
    private final Map columnMetaAttributes;
    private static final TableColumnKeyFactory TABLECOLUMN_KEY_FACTORY = (TableColumnKeyFactory)KeyFactory.create(TableColumnKeyFactory.class);

    public OverrideRepository() {
        this.tableToClassName = new HashMap();
        this.excludedColumns = new HashSet();
        this.schemaSelections = new ArrayList();
        this.compositeIdNameForTable = new HashMap();
        this.foreignKeyToOneName = new HashMap();
        this.foreignKeyToInverseName = new HashMap();
        this.foreignKeyInverseExclude = new HashMap();
        this.foreignKeyToOneExclude = new HashMap();
        this.tableMetaAttributes = new HashMap();
        this.columnMetaAttributes = new HashMap();
        this.foreignKeyToEntityInfo = new HashMap();
        this.foreignKeyToInverseEntityInfo = new HashMap();
    }

    public OverrideRepository addFile(File xmlFile) {
        log.info("Override file: " + xmlFile.getPath());
        try {
            this.addInputStream(new FileInputStream(xmlFile));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not configure overrides from file: " + xmlFile.getPath(), e);
            throw new MappingException("Could not configure overrides from file: " + xmlFile.getPath(), (Throwable)e);
        }
        return this;
    }

    public OverrideRepository addResource(String path) throws MappingException {
        log.info("Mapping resource: " + path);
        InputStream rsrc = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (rsrc == null) {
            rsrc = OverrideRepository.class.getClassLoader().getResourceAsStream(path);
        }
        if (rsrc == null) {
            throw new MappingException("Resource: " + path + " not found");
        }
        try {
            return this.addInputStream(rsrc);
        }
        catch (MappingException me) {
            throw new MappingException("Error reading resource: " + path, (Throwable)me);
        }
    }

    public OverrideRepository addInputStream(InputStream xmlInputStream) throws MappingException {
        try {
            ArrayList errors = new ArrayList();
            Document doc = this.xmlHelper.createSAXReader("XML InputStream", errors, this.entityResolver).read(new InputSource(xmlInputStream));
            if (errors.size() != 0) {
                throw new MappingException("invalid override definition", (Throwable)errors.get(0));
            }
            this.add(doc);
            OverrideRepository overrideRepository = this;
            return overrideRepository;
        }
        catch (MappingException me) {
            throw me;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not configure overrides from input stream", e);
            throw new MappingException((Throwable)e);
        }
        finally {
            try {
                xmlInputStream.close();
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "could not close input stream", ioe);
            }
        }
    }

    private OverrideRepository add(Document doc) {
        OverrideBinder.bindRoot(this, doc);
        return this;
    }

    private String getPreferredHibernateType(int sqlType, int length, int precision, int scale, boolean nullable) {
        List l = (List)this.typeMappings.get(new TypeMappingKey(sqlType, length));
        if (l == null) {
            l = (List)this.typeMappings.get(new TypeMappingKey(sqlType, Integer.MAX_VALUE));
        }
        return this.scanForMatch(sqlType, length, precision, scale, nullable, l);
    }

    private String scanForMatch(int sqlType, int length, int precision, int scale, boolean nullable, List l) {
        if (l != null) {
            for (SQLTypeMapping element : l) {
                if (element.getJDBCType() != sqlType) {
                    return null;
                }
                if (!element.match(sqlType, length, precision, scale, nullable)) continue;
                return element.getHibernateType();
            }
        }
        return null;
    }

    public OverrideRepository addTypeMapping(SQLTypeMapping sqltype) {
        TypeMappingKey key = new TypeMappingKey(sqltype);
        ArrayList<SQLTypeMapping> list = (ArrayList<SQLTypeMapping>)this.typeMappings.get(key);
        if (list == null) {
            list = new ArrayList<SQLTypeMapping>();
            this.typeMappings.put(key, list);
        }
        list.add(sqltype);
        return this;
    }

    protected String getPackageName(TableIdentifier identifier) {
        for (TableFilter tf : this.tableFilters) {
            String value = tf.getPackage(identifier);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected boolean excludeTable(TableIdentifier identifier) {
        Iterator iterator = this.tableFilters.iterator();
        boolean hasInclude = false;
        while (iterator.hasNext()) {
            TableFilter tf = (TableFilter)iterator.next();
            Boolean value = tf.exclude(identifier);
            if (value != null) {
                return value;
            }
            if (tf.getExclude().booleanValue()) continue;
            hasInclude = true;
        }
        return hasInclude;
    }

    public void addTableFilter(TableFilter filter) {
        this.tableFilters.add(filter);
    }

    public ReverseEngineeringStrategy getReverseEngineeringStrategy(ReverseEngineeringStrategy delegate) {
        return new DelegatingReverseEngineeringStrategy(delegate){

            @Override
            public boolean excludeTable(TableIdentifier ti) {
                return OverrideRepository.this.excludeTable(ti);
            }

            @Override
            public Map tableToMetaAttributes(TableIdentifier tableIdentifier) {
                return OverrideRepository.this.tableToMetaAttributes(tableIdentifier);
            }

            @Override
            public Map columnToMetaAttributes(TableIdentifier tableIdentifier, String column) {
                return OverrideRepository.this.columnToMetaAttributes(tableIdentifier, column);
            }

            @Override
            public boolean excludeColumn(TableIdentifier identifier, String columnName) {
                return OverrideRepository.this.excludedColumns.contains(TABLECOLUMN_KEY_FACTORY.newInstance(identifier, columnName));
            }

            @Override
            public String tableToCompositeIdName(TableIdentifier identifier) {
                String result = (String)OverrideRepository.this.compositeIdNameForTable.get(identifier);
                if (result == null) {
                    return super.tableToCompositeIdName(identifier);
                }
                return result;
            }

            @Override
            public List getSchemaSelections() {
                if (OverrideRepository.this.schemaSelections.isEmpty()) {
                    return super.getSchemaSelections();
                }
                return OverrideRepository.this.schemaSelections;
            }

            @Override
            public String columnToHibernateTypeName(TableIdentifier table, String columnName, int sqlType, int length, int precision, int scale, boolean nullable, boolean generatedIdentifier) {
                String result = null;
                String location = "";
                String info = " t:" + JDBCToHibernateTypeHelper.getJDBCTypeName(sqlType) + " l:" + length + " p:" + precision + " s:" + scale + " n:" + nullable + " id:" + generatedIdentifier;
                location = table != null ? Table.qualify((String)table.getCatalog(), (String)table.getSchema(), (String)table.getName()) + "." + columnName : location + " Column: " + columnName + info;
                if (table != null && columnName != null && (result = (String)OverrideRepository.this.typeForColumn.get(TABLECOLUMN_KEY_FACTORY.newInstance(table, columnName))) != null) {
                    log.fine("explicit column mapping found for [" + location + "] to [" + result + "]");
                    return result;
                }
                result = OverrideRepository.this.getPreferredHibernateType(sqlType, length, precision, scale, nullable);
                if (result == null) {
                    return super.columnToHibernateTypeName(table, columnName, sqlType, length, precision, scale, nullable, generatedIdentifier);
                }
                log.fine("<type-mapping> found for [" + location + info + "] to [" + result + "]");
                return result;
            }

            @Override
            public String tableToClassName(TableIdentifier tableIdentifier) {
                String className = (String)OverrideRepository.this.tableToClassName.get(tableIdentifier);
                if (className != null) {
                    if (className.indexOf(".") >= 0) {
                        return className;
                    }
                    String packageName = OverrideRepository.this.getPackageName(tableIdentifier);
                    if (packageName == null) {
                        return className;
                    }
                    return StringHelper.qualify((String)packageName, (String)className);
                }
                String packageName = OverrideRepository.this.getPackageName(tableIdentifier);
                if (packageName == null) {
                    return super.tableToClassName(tableIdentifier);
                }
                String string = super.tableToClassName(tableIdentifier);
                if (string == null) {
                    return null;
                }
                return StringHelper.qualify((String)packageName, (String)StringHelper.unqualify((String)string));
            }

            @Override
            public List getForeignKeys(TableIdentifier referencedTable) {
                List list = (List)OverrideRepository.this.foreignKeys.get(referencedTable);
                if (list == null) {
                    return super.getForeignKeys(referencedTable);
                }
                return list;
            }

            @Override
            public String columnToPropertyName(TableIdentifier table, String column) {
                String result = (String)OverrideRepository.this.propertyNameForColumn.get(TABLECOLUMN_KEY_FACTORY.newInstance(table, column));
                if (result == null) {
                    return super.columnToPropertyName(table, column);
                }
                return result;
            }

            @Override
            public String tableToIdentifierPropertyName(TableIdentifier tableIdentifier) {
                String result = (String)OverrideRepository.this.propertyNameForPrimaryKey.get(tableIdentifier);
                if (result == null) {
                    return super.tableToIdentifierPropertyName(tableIdentifier);
                }
                return result;
            }

            @Override
            public String getTableIdentifierStrategyName(TableIdentifier tableIdentifier) {
                String result = (String)OverrideRepository.this.identifierStrategyForTable.get(tableIdentifier);
                if (result == null) {
                    return super.getTableIdentifierStrategyName(tableIdentifier);
                }
                log.fine("tableIdentifierStrategy for " + tableIdentifier + " -> '" + result + "'");
                return result;
            }

            @Override
            public Properties getTableIdentifierProperties(TableIdentifier tableIdentifier) {
                Properties result = (Properties)OverrideRepository.this.identifierPropertiesForTable.get(tableIdentifier);
                if (result == null) {
                    return super.getTableIdentifierProperties(tableIdentifier);
                }
                return result;
            }

            @Override
            public List getPrimaryKeyColumnNames(TableIdentifier tableIdentifier) {
                List result = (List)OverrideRepository.this.primaryKeyColumnsForTable.get(tableIdentifier);
                if (result == null) {
                    return super.getPrimaryKeyColumnNames(tableIdentifier);
                }
                return result;
            }

            @Override
            public String foreignKeyToEntityName(String keyname, TableIdentifier fromTable, List fromColumnNames, TableIdentifier referencedTable, List referencedColumnNames, boolean uniqueReference) {
                String property = (String)OverrideRepository.this.foreignKeyToOneName.get(keyname);
                if (property == null) {
                    return super.foreignKeyToEntityName(keyname, fromTable, fromColumnNames, referencedTable, referencedColumnNames, uniqueReference);
                }
                return property;
            }

            @Override
            public String foreignKeyToInverseEntityName(String keyname, TableIdentifier fromTable, List fromColumnNames, TableIdentifier referencedTable, List referencedColumnNames, boolean uniqueReference) {
                String property = (String)OverrideRepository.this.foreignKeyToInverseName.get(keyname);
                if (property == null) {
                    return super.foreignKeyToInverseEntityName(keyname, fromTable, fromColumnNames, referencedTable, referencedColumnNames, uniqueReference);
                }
                return property;
            }

            @Override
            public String foreignKeyToCollectionName(String keyname, TableIdentifier fromTable, List fromColumns, TableIdentifier referencedTable, List referencedColumns, boolean uniqueReference) {
                String property = (String)OverrideRepository.this.foreignKeyToInverseName.get(keyname);
                if (property == null) {
                    return super.foreignKeyToCollectionName(keyname, fromTable, fromColumns, referencedTable, referencedColumns, uniqueReference);
                }
                return property;
            }

            @Override
            public boolean excludeForeignKeyAsCollection(String keyname, TableIdentifier fromTable, List fromColumns, TableIdentifier referencedTable, List referencedColumns) {
                Boolean bool = (Boolean)OverrideRepository.this.foreignKeyInverseExclude.get(keyname);
                if (bool != null) {
                    return bool;
                }
                return super.excludeForeignKeyAsCollection(keyname, fromTable, fromColumns, referencedTable, referencedColumns);
            }

            @Override
            public boolean excludeForeignKeyAsManytoOne(String keyname, TableIdentifier fromTable, List fromColumns, TableIdentifier referencedTable, List referencedColumns) {
                Boolean bool = (Boolean)OverrideRepository.this.foreignKeyToOneExclude.get(keyname);
                if (bool != null) {
                    return bool;
                }
                return super.excludeForeignKeyAsManytoOne(keyname, fromTable, fromColumns, referencedTable, referencedColumns);
            }

            @Override
            public AssociationInfo foreignKeyToInverseAssociationInfo(ForeignKey foreignKey) {
                AssociationInfo fkei = (AssociationInfo)OverrideRepository.this.foreignKeyToInverseEntityInfo.get(foreignKey.getName());
                if (fkei != null) {
                    return fkei;
                }
                return super.foreignKeyToInverseAssociationInfo(foreignKey);
            }

            @Override
            public AssociationInfo foreignKeyToAssociationInfo(ForeignKey foreignKey) {
                AssociationInfo fkei = (AssociationInfo)OverrideRepository.this.foreignKeyToEntityInfo.get(foreignKey.getName());
                if (fkei != null) {
                    return fkei;
                }
                return super.foreignKeyToAssociationInfo(foreignKey);
            }
        };
    }

    protected Map columnToMetaAttributes(TableIdentifier tableIdentifier, String column) {
        Map specific = (Map)this.columnMetaAttributes.get(TABLECOLUMN_KEY_FACTORY.newInstance(tableIdentifier, column));
        if (specific != null && !specific.isEmpty()) {
            return this.toMetaAttributes(specific);
        }
        return null;
    }

    protected Map tableToMetaAttributes(TableIdentifier identifier) {
        Map specific = (Map)this.tableMetaAttributes.get(identifier);
        if (specific != null && !specific.isEmpty()) {
            return this.toMetaAttributes(specific);
        }
        Map general = this.findGeneralAttributes(identifier);
        if (general != null && !general.isEmpty()) {
            return this.toMetaAttributes(general);
        }
        return null;
    }

    private Map findGeneralAttributes(TableIdentifier identifier) {
        for (TableFilter tf : this.tableFilters) {
            Map value = tf.getMetaAttributes(identifier);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private Map toMetaAttributes(Map value) {
        HashMap<String, MetaAttribute> result = new HashMap<String, MetaAttribute>();
        Set set = value.entrySet();
        for (Map.Entry entry : set) {
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            result.put(name, MetaAttributeBinder.toRealMetaAttribute(name, values));
        }
        return result;
    }

    public ReverseEngineeringStrategy getReverseEngineeringStrategy() {
        return this.getReverseEngineeringStrategy(null);
    }

    public void addTable(Table table, String wantedClassName) {
        Iterator fkIter = table.getForeignKeyIterator();
        while (fkIter.hasNext()) {
            ForeignKey fk = (ForeignKey)fkIter.next();
            TableIdentifier identifier = TableIdentifier.create(fk.getReferencedTable());
            ArrayList<ForeignKey> existing = (ArrayList<ForeignKey>)this.foreignKeys.get(identifier);
            if (existing == null) {
                existing = new ArrayList<ForeignKey>();
                this.foreignKeys.put(identifier, existing);
            }
            existing.add(fk);
        }
        this.tables.add(table);
        if (StringHelper.isNotEmpty((String)wantedClassName)) {
            this.tableToClassName.put(TableIdentifier.create(table), wantedClassName);
        }
    }

    public void setTypeNameForColumn(TableIdentifier identifier, String columnName, String type) {
        if (StringHelper.isNotEmpty((String)type)) {
            this.typeForColumn.put(TABLECOLUMN_KEY_FACTORY.newInstance(identifier, columnName), type);
        }
    }

    public void setExcludedColumn(TableIdentifier tableIdentifier, String columnName) {
        this.excludedColumns.add(TABLECOLUMN_KEY_FACTORY.newInstance(tableIdentifier, columnName));
    }

    public void setPropertyNameForColumn(TableIdentifier identifier, String columnName, String property) {
        if (StringHelper.isNotEmpty((String)property)) {
            this.propertyNameForColumn.put(TABLECOLUMN_KEY_FACTORY.newInstance(identifier, columnName), property);
        }
    }

    public void addTableIdentifierStrategy(Table table, String identifierClass, Properties params) {
        if (identifierClass != null) {
            TableIdentifier tid = TableIdentifier.create(table);
            this.identifierStrategyForTable.put(tid, identifierClass);
            this.identifierPropertiesForTable.put(tid, params);
        }
    }

    public void addPrimaryKeyNamesForTable(Table table, List boundColumnNames, String propertyName, String compositeIdName) {
        TableIdentifier tableIdentifier = TableIdentifier.create(table);
        if (boundColumnNames != null && !boundColumnNames.isEmpty()) {
            this.primaryKeyColumnsForTable.put(tableIdentifier, boundColumnNames);
        }
        if (StringHelper.isNotEmpty((String)propertyName)) {
            this.propertyNameForPrimaryKey.put(tableIdentifier, propertyName);
        }
        if (StringHelper.isNotEmpty((String)compositeIdName)) {
            this.compositeIdNameForTable.put(tableIdentifier, compositeIdName);
        }
    }

    public void addSchemaSelection(SchemaSelection schemaSelection) {
        this.schemaSelections.add(schemaSelection);
    }

    public void addForeignKeyInfo(String constraintName, String toOneProperty, Boolean excludeToOne, String inverseProperty, Boolean excludeInverse, AssociationInfo associationInfo, AssociationInfo inverseAssociationInfo) {
        if (StringHelper.isNotEmpty((String)toOneProperty)) {
            this.foreignKeyToOneName.put(constraintName, toOneProperty);
        }
        if (StringHelper.isNotEmpty((String)inverseProperty)) {
            this.foreignKeyToInverseName.put(constraintName, inverseProperty);
        }
        if (excludeInverse != null) {
            this.foreignKeyInverseExclude.put(constraintName, excludeInverse);
        }
        if (excludeToOne != null) {
            this.foreignKeyToOneExclude.put(constraintName, excludeToOne);
        }
        if (associationInfo != null) {
            this.foreignKeyToEntityInfo.put(constraintName, associationInfo);
        }
        if (inverseAssociationInfo != null) {
            this.foreignKeyToInverseEntityInfo.put(constraintName, inverseAssociationInfo);
        }
    }

    public void addMetaAttributeInfo(Table table, Map map) {
        if (map != null && !map.isEmpty()) {
            this.tableMetaAttributes.put(TableIdentifier.create(table), map);
        }
    }

    public void addMetaAttributeInfo(TableIdentifier tableIdentifier, String name, MultiMap map) {
        if (map != null && !map.isEmpty()) {
            this.columnMetaAttributes.put(TABLECOLUMN_KEY_FACTORY.newInstance(tableIdentifier, name), map);
        }
    }

    static interface TableColumnKeyFactory {
        public Object newInstance(TableIdentifier var1, String var2);
    }

    static class TypeMappingKey {
        int type;
        int length;

        TypeMappingKey(SQLTypeMapping mpa) {
            this.type = mpa.getJDBCType();
            this.length = mpa.getLength();
        }

        public TypeMappingKey(int sqlType, int length) {
            this.type = sqlType;
            this.length = length;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TypeMappingKey)) {
                return false;
            }
            TypeMappingKey other = (TypeMappingKey)obj;
            return this.type == other.type && this.length == other.length;
        }

        public int hashCode() {
            return (this.type + this.length) % 17;
        }

        public String toString() {
            return this.getClass() + "(type:" + this.type + ", length:" + this.length + ")";
        }
    }
}

