/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.ProgressListener;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.SchemaSelection;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableProcessor {
    private static final Logger log = LoggerFactory.getLogger(TableProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Table> processTables(MetaDataDialect metaDataDialect, ReverseEngineeringStrategy revengStrategy, String defaultSchema, String defaultCatalog, DatabaseCollector dbs, SchemaSelection schemaSelection, Set<Table> hasIndices, ProgressListener progress) {
        Object var8_8 = null;
        Iterator<Map<String, Object>> tableIterator = null;
        ArrayList<HashMap<String, Object>> tables = new ArrayList<HashMap<String, Object>>();
        boolean multiSchema = false;
        try {
            progress.startSubTask("Finding tables in " + schemaSelection);
            tableIterator = metaDataDialect.getTables(StringHelper.replace((String)schemaSelection.getMatchCatalog(), (String)".*", (String)"%"), StringHelper.replace((String)schemaSelection.getMatchSchema(), (String)".*", (String)"%"), StringHelper.replace((String)schemaSelection.getMatchTable(), (String)".*", (String)"%"));
            String[] lastQualifier = null;
            String[] foundQualifier = new String[2];
            while (tableIterator.hasNext()) {
                Map<String, Object> map = tableIterator.next();
                String tableName = (String)map.get("TABLE_NAME");
                String schemaName = (String)map.get("TABLE_SCHEM");
                String catalogName = (String)map.get("TABLE_CAT");
                TableIdentifier ti = new TableIdentifier(catalogName, schemaName, tableName);
                if (revengStrategy.excludeTable(ti)) {
                    log.debug("Table " + ti + " excluded by strategy");
                    continue;
                }
                if (!multiSchema) {
                    foundQualifier[0] = catalogName;
                    foundQualifier[1] = schemaName;
                    if (lastQualifier == null) {
                        lastQualifier = new String[]{foundQualifier[0], foundQualifier[1]};
                    }
                    if (!TableProcessor.safeEquals(lastQualifier[0], foundQualifier[0]) || !TableProcessor.safeEquals(lastQualifier[1], foundQualifier[1])) {
                        multiSchema = true;
                    }
                }
                tables.add(new HashMap<String, Object>(map));
            }
        }
        finally {
            try {
                if (tableIterator != null) {
                    metaDataDialect.close(tableIterator);
                }
            }
            catch (Exception lastQualifier) {}
        }
        ArrayList<Table> processedTables = new ArrayList<Table>();
        for (Map<String, Object> map : tables) {
            String tableName = (String)map.get("TABLE_NAME");
            String schemaName = (String)map.get("TABLE_SCHEM");
            String catalogName = (String)map.get("TABLE_CAT");
            TableIdentifier ti = new TableIdentifier(catalogName, schemaName, tableName);
            if (revengStrategy.excludeTable(ti)) {
                log.debug("Table " + ti + " excluded by strategy");
                continue;
            }
            String comment = (String)map.get("REMARKS");
            String tableType = (String)map.get("TABLE_TYPE");
            if (dbs.getTable(schemaName, catalogName, tableName) != null) {
                log.debug("Ignoring " + tableName + " since it has already been processed");
                continue;
            }
            if ("TABLE".equalsIgnoreCase(tableType) || "VIEW".equalsIgnoreCase(tableType) || "SYNONYM".equals(tableType)) {
                if (schemaName != null && schemaName.trim().length() == 0) {
                    schemaName = null;
                }
                if (catalogName != null && catalogName.trim().length() == 0) {
                    catalogName = null;
                }
                log.debug("Adding table " + tableName + " of type " + tableType);
                progress.startSubTask("Found " + tableName);
                Table table = dbs.addTable(TableProcessor.getSchemaForModel(schemaName, defaultSchema), TableProcessor.getCatalogForModel(catalogName, defaultCatalog), tableName);
                table.setComment(comment);
                if (tableType.equalsIgnoreCase("TABLE")) {
                    hasIndices.add(table);
                }
                processedTables.add(table);
                continue;
            }
            log.debug("Ignoring table " + tableName + " of type " + tableType);
        }
        return processedTables;
    }

    private static boolean safeEquals(Object value, Object tf) {
        if (value == tf) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return value.equals(tf);
    }

    private static String getCatalogForModel(String catalog, String defaultCatalog) {
        if (catalog == null) {
            return null;
        }
        if (catalog.equals(defaultCatalog)) {
            return null;
        }
        return catalog;
    }

    private static String getSchemaForModel(String schema, String defaultSchema) {
        if (schema == null) {
            return null;
        }
        if (schema.equals(defaultSchema)) {
            return null;
        }
        return schema;
    }
}

