/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCBinder;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class JDBCMetaDataConfiguration
extends Configuration {
    private static final Logger log = Logger.getLogger(JDBCMetaDataConfiguration.class);
    private ReverseEngineeringStrategy revEngStrategy = new DefaultReverseEngineeringStrategy();
    private ServiceRegistry serviceRegistry = null;
    private boolean ignoreconfigxmlmapppings = true;
    private boolean preferBasicCompositeIds = true;

    public ServiceRegistry getServiceRegistry() {
        if (this.serviceRegistry == null) {
            this.serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)this.getProperties()).build();
        }
        return this.serviceRegistry;
    }

    public void readFromJDBC() {
        JDBCBinder binder = new JDBCBinder(this.getServiceRegistry(), this.getProperties(), this.createMappings(), this.getReverseEngineeringStrategy(), this.preferBasicCompositeIds());
        binder.readFromDatabase(null, null, JDBCMetaDataConfiguration.buildMapping(this));
    }

    private static Mapping buildMapping(final Configuration cfg) {
        return new Mapping(){

            public Type getIdentifierType(String persistentClass) throws MappingException {
                PersistentClass pc = cfg.getClassMapping(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                return pc.getIdentifier().getType();
            }

            public String getIdentifierPropertyName(String persistentClass) throws MappingException {
                PersistentClass pc = cfg.getClassMapping(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                if (!pc.hasIdentifierProperty()) {
                    return null;
                }
                return pc.getIdentifierProperty().getName();
            }

            public Type getReferencedPropertyType(String persistentClass, String propertyName) throws MappingException {
                PersistentClass pc = cfg.getClassMapping(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                Property prop = pc.getProperty(propertyName);
                if (prop == null) {
                    throw new MappingException("property not known: " + persistentClass + '.' + propertyName);
                }
                return prop.getType();
            }

            public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
                return null;
            }
        };
    }

    public boolean preferBasicCompositeIds() {
        return this.preferBasicCompositeIds;
    }

    public void setPreferBasicCompositeIds(boolean flag) {
        this.preferBasicCompositeIds = flag;
    }

    protected void parseMappingElement(Element subelement, String name) {
        if (this.ignoreconfigxmlmapppings) {
            log.info((Object)("Ignoring " + name + " mapping"));
        }
    }

    public void setReverseEngineeringStrategy(ReverseEngineeringStrategy reverseEngineeringStrategy) {
        this.revEngStrategy = reverseEngineeringStrategy;
    }

    public ReverseEngineeringStrategy getReverseEngineeringStrategy() {
        return this.revEngStrategy;
    }
}

